/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.yedaxia.apidocs.BuildToolType;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.ParseUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Utils {
    public static String toPrettyJson(Object map) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(map);
    }

    public static String toJson(Object map) {
        Gson gson = new Gson();
        return gson.toJson(map);
    }

    public static <T> T jsonToObject(String json, Class<T> type) {
        Gson gson = new Gson();
        return (T)gson.fromJson(json, type);
    }

    public static void writeToDisk(File f, String content) throws IOException {
        Utils.mkdirsForFile(f);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8"));
        writer.write(content);
        writer.close();
    }

    public static void closeSilently(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String streamToString(InputStream in) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "utf-8");
        char[] buffer = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer)) != -1) {
            stringBuilder.append(buffer, 0, bytesRead);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static String removeQuotations(String rawUrl) {
        return rawUrl.replace("\"", "").trim();
    }

    public static String cleanCommentContent(String content) {
        return content.replace("*", "").replace("\n", "").trim();
    }

    public static String getActionUrl(String baseUrl, String relativeUrl) {
        if (relativeUrl == null) {
            return "";
        }
        if (baseUrl == null) {
            return relativeUrl;
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!relativeUrl.startsWith("/")) {
            relativeUrl = "/" + relativeUrl;
        }
        return baseUrl + relativeUrl;
    }

    public static String decapitalize(String name) {
        if (name != null && name.length() != 0) {
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    public static String capitalize(String name) {
        if (name != null && name.length() != 0) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    public static String joinArrayString(String[] array, String separator) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = array.length;
        for (int i = 0; i != len; ++i) {
            builder.append(array[i]);
            if (i == len - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String getJavaFileName(File javaFile) {
        String fileName = javaFile.getName();
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static void wideSearchFile(File rootPath, FilenameFilter filter, List<File> result, boolean stopAtFirstResult) {
        File[] fileList = rootPath.listFiles();
        ArrayList<File> dirPaths = new ArrayList<File>();
        for (File f : fileList) {
            if (f.isFile() && filter.accept(f, f.getName())) {
                result.add(f);
                if (!stopAtFirstResult) continue;
                return;
            }
            if (!f.isDirectory()) continue;
            dirPaths.add(f);
        }
        for (File dir : dirPaths) {
            if (stopAtFirstResult && !result.isEmpty()) {
                return;
            }
            Utils.wideSearchFile(dir, filter, result, stopAtFirstResult);
        }
    }

    public static boolean hasDirInFile(File f, File stopPath, String dirName) {
        for (File p = f.getParentFile(); stopPath == null && p != null || stopPath != null && !p.getAbsolutePath().equals(stopPath.getAbsolutePath()); p = p.getParentFile()) {
            if (!dirName.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayFramework(File projectDir) {
        File ymlFile = new File(projectDir, "conf/dependencies.yml");
        if (!ymlFile.exists()) {
            return false;
        }
        File routesFile = new File(projectDir, "conf/routes");
        return routesFile.exists();
    }

    public static boolean isSpringFramework(File javaSrcDir) {
        ArrayList<File> result = new ArrayList<File>();
        Utils.wideSearchFile(javaSrcDir, new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith(".java") && ParseUtils.compilationUnit(f).getImports().stream().anyMatch(im -> im.getNameAsString().contains("org.springframework.web"));
            }
        }, result, true);
        return result.size() > 0;
    }

    public static boolean isJFinalFramework(File javaSrcDir) {
        ArrayList<File> result = new ArrayList<File>();
        Utils.wideSearchFile(javaSrcDir, new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith(".java") && ParseUtils.compilationUnit(f).getImports().stream().anyMatch(im -> im.getNameAsString().contains("com.jfinal.core"));
            }
        }, result, true);
        return result.size() > 0;
    }

    public static boolean isValueType(Object value) {
        return value instanceof Number || value instanceof String || value instanceof Date;
    }

    public static String getClassName(String packageClass) {
        String[] parts = packageClass.split("\\.");
        return parts[parts.length - 1];
    }

    private static BuildToolType getProjectBuildTool(File projectDir) {
        if (new File(projectDir, "settings.gradle").exists()) {
            return BuildToolType.GRADLE;
        }
        if (new File(projectDir, "pom.xml").exists()) {
            return BuildToolType.MAVEN;
        }
        return BuildToolType.UNKOWN;
    }

    public static List<String> getModuleNames(File projectDir) {
        BuildToolType buildToolType = Utils.getProjectBuildTool(projectDir);
        final ArrayList<String> moduleNames = new ArrayList<String>();
        if (buildToolType == BuildToolType.GRADLE) {
            try {
                String lineText;
                BufferedReader settingReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(projectDir, "settings.gradle"))));
                String keyword = "include ";
                while ((lineText = settingReader.readLine()) != null) {
                    int inIndex = lineText.indexOf(keyword);
                    if (inIndex == -1) continue;
                    moduleNames.add(lineText.substring(inIndex + keyword.length()).replace("'", "").replace("\"", ""));
                }
                Utils.closeSilently(settingReader);
            }
            catch (IOException ex) {
                LogUtils.error("read setting.gradle error", ex);
            }
        }
        if (buildToolType == BuildToolType.MAVEN) {
            try {
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                saxParser.parse(new File(projectDir, "pom.xml"), new DefaultHandler(){
                    String moduleName;
                    boolean isModuleTag;

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("module".equalsIgnoreCase(qName)) {
                            this.isModuleTag = true;
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("module".equalsIgnoreCase(qName)) {
                            moduleNames.add(this.moduleName);
                            this.isModuleTag = false;
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.isModuleTag) {
                            this.moduleName = new String(ch, start, length);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogUtils.error("read pom.xml error", ex);
            }
        }
        if (!moduleNames.isEmpty()) {
            LogUtils.info("find multi modules in this project: %s", Arrays.toString(moduleNames.toArray()));
        }
        return moduleNames;
    }

    public static void mkdirsForFile(File file) {
        if (file.isFile() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }
}

