/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.HedgingPolicy;
import io.grpc.internal.RetriableStream;
import io.grpc.internal.RetryPolicy;
import io.grpc.internal.ServiceConfigUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ManagedChannelServiceConfig {
    private final Map<String, MethodInfo> serviceMethodMap;
    private final Map<String, MethodInfo> serviceMap;
    @Nullable
    private final RetriableStream.Throttle retryThrottling;
    @Nullable
    private final Object loadBalancingConfig;

    ManagedChannelServiceConfig(Map<String, MethodInfo> serviceMethodMap, Map<String, MethodInfo> serviceMap, @Nullable RetriableStream.Throttle retryThrottling, @Nullable Object loadBalancingConfig) {
        this.serviceMethodMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(serviceMethodMap));
        this.serviceMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(serviceMap));
        this.retryThrottling = retryThrottling;
        this.loadBalancingConfig = loadBalancingConfig;
    }

    static ManagedChannelServiceConfig fromServiceConfig(Map<String, ?> serviceConfig, boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit, @Nullable Object loadBalancingConfig) {
        RetriableStream.Throttle retryThrottling = null;
        if (retryEnabled) {
            retryThrottling = ServiceConfigUtil.getThrottlePolicy(serviceConfig);
        }
        HashMap<String, MethodInfo> serviceMethodMap = new HashMap<String, MethodInfo>();
        HashMap<String, MethodInfo> serviceMap = new HashMap<String, MethodInfo>();
        List<Map<String, ?>> methodConfigs = ServiceConfigUtil.getMethodConfigFromServiceConfig(serviceConfig);
        if (methodConfigs == null) {
            return new ManagedChannelServiceConfig(serviceMethodMap, serviceMap, retryThrottling, loadBalancingConfig);
        }
        for (Map<String, ?> methodConfig : methodConfigs) {
            MethodInfo info = new MethodInfo(methodConfig, retryEnabled, maxRetryAttemptsLimit, maxHedgedAttemptsLimit);
            List<Map<String, ?>> nameList = ServiceConfigUtil.getNameListFromMethodConfig(methodConfig);
            Preconditions.checkArgument((nameList != null && !nameList.isEmpty() ? 1 : 0) != 0, (String)"no names in method config %s", methodConfig);
            for (Map<String, ?> name : nameList) {
                String serviceName = ServiceConfigUtil.getServiceFromName(name);
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"missing service name");
                String methodName = ServiceConfigUtil.getMethodFromName(name);
                if (Strings.isNullOrEmpty((String)methodName)) {
                    Preconditions.checkArgument((!serviceMap.containsKey(serviceName) ? 1 : 0) != 0, (String)"Duplicate service %s", (Object)serviceName);
                    serviceMap.put(serviceName, info);
                    continue;
                }
                String fullMethodName = MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName);
                Preconditions.checkArgument((!serviceMethodMap.containsKey(fullMethodName) ? 1 : 0) != 0, (String)"Duplicate method name %s", (Object)fullMethodName);
                serviceMethodMap.put(fullMethodName, info);
            }
        }
        return new ManagedChannelServiceConfig(serviceMethodMap, serviceMap, retryThrottling, loadBalancingConfig);
    }

    Map<String, MethodInfo> getServiceMap() {
        return this.serviceMap;
    }

    Map<String, MethodInfo> getServiceMethodMap() {
        return this.serviceMethodMap;
    }

    @Nullable
    @VisibleForTesting
    Object getLoadBalancingConfig() {
        return this.loadBalancingConfig;
    }

    static final class MethodInfo {
        final Long timeoutNanos;
        final Boolean waitForReady;
        final Integer maxInboundMessageSize;
        final Integer maxOutboundMessageSize;
        final RetryPolicy retryPolicy;
        final HedgingPolicy hedgingPolicy;

        MethodInfo(Map<String, ?> methodConfig, boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit) {
            this.timeoutNanos = ServiceConfigUtil.getTimeoutFromMethodConfig(methodConfig);
            this.waitForReady = ServiceConfigUtil.getWaitForReadyFromMethodConfig(methodConfig);
            this.maxInboundMessageSize = ServiceConfigUtil.getMaxResponseMessageBytesFromMethodConfig(methodConfig);
            if (this.maxInboundMessageSize != null) {
                Preconditions.checkArgument((this.maxInboundMessageSize >= 0 ? 1 : 0) != 0, (String)"maxInboundMessageSize %s exceeds bounds", (Object)this.maxInboundMessageSize);
            }
            this.maxOutboundMessageSize = ServiceConfigUtil.getMaxRequestMessageBytesFromMethodConfig(methodConfig);
            if (this.maxOutboundMessageSize != null) {
                Preconditions.checkArgument((this.maxOutboundMessageSize >= 0 ? 1 : 0) != 0, (String)"maxOutboundMessageSize %s exceeds bounds", (Object)this.maxOutboundMessageSize);
            }
            Map<String, ?> retryPolicyMap = retryEnabled ? ServiceConfigUtil.getRetryPolicyFromMethodConfig(methodConfig) : null;
            this.retryPolicy = retryPolicyMap == null ? RetryPolicy.DEFAULT : MethodInfo.retryPolicy(retryPolicyMap, maxRetryAttemptsLimit);
            Map<String, ?> hedgingPolicyMap = retryEnabled ? ServiceConfigUtil.getHedgingPolicyFromMethodConfig(methodConfig) : null;
            this.hedgingPolicy = hedgingPolicyMap == null ? HedgingPolicy.DEFAULT : MethodInfo.hedgingPolicy(hedgingPolicyMap, maxHedgedAttemptsLimit);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timeoutNanos, this.waitForReady, this.maxInboundMessageSize, this.maxOutboundMessageSize, this.retryPolicy, this.hedgingPolicy});
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)other;
            return Objects.equal((Object)this.timeoutNanos, (Object)that.timeoutNanos) && Objects.equal((Object)this.waitForReady, (Object)that.waitForReady) && Objects.equal((Object)this.maxInboundMessageSize, (Object)that.maxInboundMessageSize) && Objects.equal((Object)this.maxOutboundMessageSize, (Object)that.maxOutboundMessageSize) && Objects.equal((Object)this.retryPolicy, (Object)that.retryPolicy) && Objects.equal((Object)this.hedgingPolicy, (Object)that.hedgingPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timeoutNanos", (Object)this.timeoutNanos).add("waitForReady", (Object)this.waitForReady).add("maxInboundMessageSize", (Object)this.maxInboundMessageSize).add("maxOutboundMessageSize", (Object)this.maxOutboundMessageSize).add("retryPolicy", (Object)this.retryPolicy).add("hedgingPolicy", (Object)this.hedgingPolicy).toString();
        }

        private static RetryPolicy retryPolicy(Map<String, ?> retryPolicy, int maxAttemptsLimit) {
            int maxAttempts = (Integer)Preconditions.checkNotNull((Object)ServiceConfigUtil.getMaxAttemptsFromRetryPolicy(retryPolicy), (Object)"maxAttempts cannot be empty");
            Preconditions.checkArgument((maxAttempts >= 2 ? 1 : 0) != 0, (String)"maxAttempts must be greater than 1: %s", (int)maxAttempts);
            maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
            long initialBackoffNanos = (Long)Preconditions.checkNotNull((Object)ServiceConfigUtil.getInitialBackoffNanosFromRetryPolicy(retryPolicy), (Object)"initialBackoff cannot be empty");
            Preconditions.checkArgument((initialBackoffNanos > 0L ? 1 : 0) != 0, (String)"initialBackoffNanos must be greater than 0: %s", (long)initialBackoffNanos);
            long maxBackoffNanos = (Long)Preconditions.checkNotNull((Object)ServiceConfigUtil.getMaxBackoffNanosFromRetryPolicy(retryPolicy), (Object)"maxBackoff cannot be empty");
            Preconditions.checkArgument((maxBackoffNanos > 0L ? 1 : 0) != 0, (String)"maxBackoff must be greater than 0: %s", (long)maxBackoffNanos);
            double backoffMultiplier = (Double)Preconditions.checkNotNull((Object)ServiceConfigUtil.getBackoffMultiplierFromRetryPolicy(retryPolicy), (Object)"backoffMultiplier cannot be empty");
            Preconditions.checkArgument((backoffMultiplier > 0.0 ? 1 : 0) != 0, (String)"backoffMultiplier must be greater than 0: %s", (Object)backoffMultiplier);
            List<String> rawCodes = ServiceConfigUtil.getRetryableStatusCodesFromRetryPolicy(retryPolicy);
            Preconditions.checkNotNull(rawCodes, (Object)"rawCodes must be present");
            Preconditions.checkArgument((!rawCodes.isEmpty() ? 1 : 0) != 0, (Object)"rawCodes can't be empty");
            EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
            for (String rawCode : rawCodes) {
                Verify.verify((!"OK".equals(rawCode) ? 1 : 0) != 0, (String)"rawCode can not be \"OK\"", (Object[])new Object[0]);
                codes.add(Status.Code.valueOf((String)rawCode));
            }
            Set<Status.Code> retryableStatusCodes = Collections.unmodifiableSet(codes);
            return new RetryPolicy(maxAttempts, initialBackoffNanos, maxBackoffNanos, backoffMultiplier, retryableStatusCodes);
        }

        private static HedgingPolicy hedgingPolicy(Map<String, ?> hedgingPolicy, int maxAttemptsLimit) {
            int maxAttempts = (Integer)Preconditions.checkNotNull((Object)ServiceConfigUtil.getMaxAttemptsFromHedgingPolicy(hedgingPolicy), (Object)"maxAttempts cannot be empty");
            Preconditions.checkArgument((maxAttempts >= 2 ? 1 : 0) != 0, (String)"maxAttempts must be greater than 1: %s", (int)maxAttempts);
            maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
            long hedgingDelayNanos = (Long)Preconditions.checkNotNull((Object)ServiceConfigUtil.getHedgingDelayNanosFromHedgingPolicy(hedgingPolicy), (Object)"hedgingDelay cannot be empty");
            Preconditions.checkArgument((hedgingDelayNanos >= 0L ? 1 : 0) != 0, (String)"hedgingDelay must not be negative: %s", (long)hedgingDelayNanos);
            List<String> rawCodes = ServiceConfigUtil.getNonFatalStatusCodesFromHedgingPolicy(hedgingPolicy);
            Preconditions.checkNotNull(rawCodes, (Object)"rawCodes must be present");
            Preconditions.checkArgument((!rawCodes.isEmpty() ? 1 : 0) != 0, (Object)"rawCodes can't be empty");
            EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
            for (String rawCode : rawCodes) {
                Verify.verify((!"OK".equals(rawCode) ? 1 : 0) != 0, (String)"rawCode can not be \"OK\"", (Object[])new Object[0]);
                codes.add(Status.Code.valueOf((String)rawCode));
            }
            Set<Status.Code> nonFatalStatusCodes = Collections.unmodifiableSet(codes);
            return new HedgingPolicy(maxAttempts, hedgingDelayNanos, nonFatalStatusCodes);
        }
    }
}

