/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.netty.StreamIdHolder;
import io.grpc.netty.WriteQueue;
import io.netty.handler.codec.http2.Http2Headers;

class SendResponseHeadersCommand
extends WriteQueue.AbstractQueuedCommand {
    private final StreamIdHolder stream;
    private final Http2Headers headers;
    private final boolean endOfStream;

    SendResponseHeadersCommand(StreamIdHolder stream, Http2Headers headers, boolean endOfStream) {
        this.stream = (StreamIdHolder)Preconditions.checkNotNull((Object)stream);
        this.headers = (Http2Headers)Preconditions.checkNotNull((Object)headers);
        this.endOfStream = endOfStream;
    }

    StreamIdHolder stream() {
        return this.stream;
    }

    Http2Headers headers() {
        return this.headers;
    }

    boolean endOfStream() {
        return this.endOfStream;
    }

    public boolean equals(Object that) {
        if (that == null || !that.getClass().equals(SendResponseHeadersCommand.class)) {
            return false;
        }
        SendResponseHeadersCommand thatCmd = (SendResponseHeadersCommand)that;
        return thatCmd.stream.equals(this.stream) && thatCmd.headers.equals(this.headers) && thatCmd.endOfStream == this.endOfStream;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(stream=" + this.stream.id() + ", headers=" + this.headers + ", endOfStream=" + this.endOfStream + ")";
    }

    public int hashCode() {
        return this.stream.hashCode();
    }
}

