/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.re2j.Pattern;
import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.RouteMatch;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

final class XdsNameResolver
extends NameResolver {
    private final XdsLogger logger;
    private final String authority;
    private final XdsClient.XdsChannelFactory channelFactory;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Bootstrapper bootstrapper;
    @Nullable
    private ObjectPool<XdsClient> xdsClientPool;
    @Nullable
    private XdsClient xdsClient;

    XdsNameResolver(String name, NameResolver.Args args, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, XdsClient.XdsChannelFactory channelFactory, Bootstrapper bootstrapper) {
        this.authority = GrpcUtil.checkAuthority((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
        this.channelFactory = (XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)args.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)args.getScheduledExecutorService(), (Object)"timeService");
        this.serviceConfigParser = (NameResolver.ServiceConfigParser)Preconditions.checkNotNull((Object)args.getServiceConfigParser(), (Object)"serviceConfigParser");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-resolver", (String)name));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created resolver for {0}", name);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        Bootstrapper.BootstrapInfo bootstrapInfo;
        try {
            bootstrapInfo = this.bootstrapper.readBootstrap();
        }
        catch (Exception e) {
            listener.onError(Status.UNAVAILABLE.withDescription("Failed to bootstrap").withCause((Throwable)e));
            return;
        }
        final List<Bootstrapper.ServerInfo> serverList = bootstrapInfo.getServers();
        final Node node = bootstrapInfo.getNode();
        if (serverList.isEmpty()) {
            listener.onError(Status.UNAVAILABLE.withDescription("No management server provided by bootstrap"));
            return;
        }
        XdsClient.XdsClientFactory xdsClientFactory = new XdsClient.XdsClientFactory(){

            @Override
            XdsClient createXdsClient() {
                return new XdsClientImpl(XdsNameResolver.this.authority, serverList, XdsNameResolver.this.channelFactory, node, XdsNameResolver.this.syncContext, XdsNameResolver.this.timeService, XdsNameResolver.this.backoffPolicyProvider, (Supplier<Stopwatch>)XdsNameResolver.this.stopwatchSupplier);
            }
        };
        this.xdsClientPool = new XdsClient.RefCountedXdsClientObjectPool(xdsClientFactory);
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.xdsClient.watchConfigData(this.authority, new ConfigWatcherImpl(listener));
    }

    @VisibleForTesting
    static ImmutableMap<String, ?> generateXdsRoutingRawConfig(List<EnvoyProtoData.Route> routes) {
        ArrayList rawRoutes = new ArrayList();
        LinkedHashMap<String, ImmutableMap> rawActions = new LinkedHashMap<String, ImmutableMap>();
        HashMap<EnvoyProtoData.RouteAction, String> existingActions = new HashMap<EnvoyProtoData.RouteAction, String>();
        for (EnvoyProtoData.Route route : routes) {
            String actionName;
            EnvoyProtoData.RouteAction routeAction = route.getRouteAction();
            if (existingActions.containsKey(routeAction)) {
                actionName = (String)existingActions.get(routeAction);
            } else {
                ImmutableMap<String, ?> actionPolicy;
                if (routeAction.getCluster() != null) {
                    actionName = "cds:" + routeAction.getCluster();
                    actionPolicy = XdsNameResolver.generateCdsRawConfig(routeAction.getCluster());
                } else {
                    StringBuilder sb = new StringBuilder("weighted:");
                    List<EnvoyProtoData.ClusterWeight> clusterWeights = routeAction.getWeightedCluster();
                    for (EnvoyProtoData.ClusterWeight clusterWeight : clusterWeights) {
                        sb.append(clusterWeight.getName()).append('_');
                    }
                    sb.append(routeAction.hashCode());
                    actionName = sb.toString();
                    if (rawActions.containsKey(actionName)) {
                        actionName = actionName + "_" + existingActions.size();
                    }
                    actionPolicy = XdsNameResolver.generateWeightedTargetRawConfig(clusterWeights);
                }
                existingActions.put(routeAction, actionName);
                ImmutableList childPolicies = ImmutableList.of(actionPolicy);
                rawActions.put(actionName, ImmutableMap.of((Object)"childPolicy", (Object)childPolicies));
            }
            ImmutableMap<String, ?> configRoute = XdsNameResolver.convertToRawRoute(route.getRouteMatch(), actionName);
            rawRoutes.add(configRoute);
        }
        return ImmutableMap.of((Object)"xds_routing_experimental", (Object)ImmutableMap.of((Object)"route", Collections.unmodifiableList(rawRoutes), (Object)"action", Collections.unmodifiableMap(rawActions)));
    }

    @VisibleForTesting
    static ImmutableMap<String, ?> convertToRawRoute(RouteMatch routeMatch, String actionName) {
        RouteMatch.FractionMatcher matchFraction;
        ImmutableMap.Builder configRouteBuilder = new ImmutableMap.Builder();
        RouteMatch.PathMatcher pathMatcher = routeMatch.getPathMatch();
        String path = pathMatcher.getPath();
        String prefix = pathMatcher.getPrefix();
        Pattern regex = pathMatcher.getRegEx();
        if (path != null) {
            configRouteBuilder.put((Object)"path", (Object)path);
        }
        if (prefix != null) {
            configRouteBuilder.put((Object)"prefix", (Object)prefix);
        }
        if (regex != null) {
            configRouteBuilder.put((Object)"regex", (Object)regex.pattern());
        }
        ImmutableList.Builder rawHeaderMatcherListBuilder = new ImmutableList.Builder();
        List<RouteMatch.HeaderMatcher> headerMatchers = routeMatch.getHeaderMatchers();
        for (RouteMatch.HeaderMatcher headerMatcher : headerMatchers) {
            ImmutableMap.Builder rawHeaderMatcherBuilder = new ImmutableMap.Builder();
            rawHeaderMatcherBuilder.put((Object)"name", (Object)headerMatcher.getName());
            String exactMatch = headerMatcher.getExactMatch();
            Pattern regexMatch = headerMatcher.getRegExMatch();
            RouteMatch.HeaderMatcher.Range rangeMatch = headerMatcher.getRangeMatch();
            Boolean presentMatch = headerMatcher.getPresentMatch();
            String prefixMatch = headerMatcher.getPrefixMatch();
            String suffixMatch = headerMatcher.getSuffixMatch();
            if (exactMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"exactMatch", (Object)exactMatch);
            }
            if (regexMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"regexMatch", (Object)regexMatch.pattern());
            }
            if (rangeMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"rangeMatch", (Object)ImmutableMap.of((Object)"start", (Object)rangeMatch.getStart(), (Object)"end", (Object)rangeMatch.getEnd()));
            }
            if (presentMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"presentMatch", (Object)presentMatch);
            }
            if (prefixMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"prefixMatch", (Object)prefixMatch);
            }
            if (suffixMatch != null) {
                rawHeaderMatcherBuilder.put((Object)"suffixMatch", (Object)suffixMatch);
            }
            rawHeaderMatcherBuilder.put((Object)"invertMatch", (Object)headerMatcher.isInvertedMatch());
            rawHeaderMatcherListBuilder.add((Object)rawHeaderMatcherBuilder.build());
        }
        ImmutableList rawHeaderMatchers = rawHeaderMatcherListBuilder.build();
        if (!rawHeaderMatchers.isEmpty()) {
            configRouteBuilder.put((Object)"headers", (Object)rawHeaderMatchers);
        }
        if ((matchFraction = routeMatch.getFractionMatch()) != null) {
            configRouteBuilder.put((Object)"matchFraction", (Object)ImmutableMap.of((Object)"numerator", (Object)matchFraction.getNumerator(), (Object)"denominator", (Object)matchFraction.getDenominator()));
        }
        configRouteBuilder.put((Object)"action", (Object)actionName);
        return configRouteBuilder.build();
    }

    @VisibleForTesting
    static ImmutableMap<String, ?> generateWeightedTargetRawConfig(List<EnvoyProtoData.ClusterWeight> clusterWeights) {
        LinkedHashMap<String, ImmutableMap> targets = new LinkedHashMap<String, ImmutableMap>();
        for (EnvoyProtoData.ClusterWeight clusterWeight : clusterWeights) {
            ImmutableMap<String, ?> childPolicy = XdsNameResolver.generateCdsRawConfig(clusterWeight.getName());
            ImmutableMap weightedConfig = ImmutableMap.of((Object)"weight", (Object)clusterWeight.getWeight(), (Object)"childPolicy", (Object)ImmutableList.of(childPolicy));
            targets.put(clusterWeight.getName(), weightedConfig);
        }
        return ImmutableMap.of((Object)"weighted_target_experimental", (Object)ImmutableMap.of((Object)"targets", targets));
    }

    private static ImmutableMap<String, ?> generateCdsRawConfig(String clusterName) {
        return ImmutableMap.of((Object)"cds_experimental", (Object)ImmutableMap.of((Object)"cluster", (Object)clusterName));
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private class ConfigWatcherImpl
    implements XdsClient.ConfigWatcher {
        final NameResolver.Listener2 listener;

        ConfigWatcherImpl(NameResolver.Listener2 listener) {
            this.listener = listener;
        }

        @Override
        public void onConfigChanged(XdsClient.ConfigUpdate update) {
            ImmutableMap<String, ?> rawLbConfig;
            if (update.getRoutes().size() > 1) {
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received config update with {0} routes from xDS client {1}", update.getRoutes().size(), XdsNameResolver.this.xdsClient);
                rawLbConfig = XdsNameResolver.generateXdsRoutingRawConfig(update.getRoutes());
            } else {
                EnvoyProtoData.Route defaultRoute = (EnvoyProtoData.Route)Iterables.getOnlyElement(update.getRoutes());
                EnvoyProtoData.RouteAction action = defaultRoute.getRouteAction();
                String clusterName = defaultRoute.getRouteAction().getCluster();
                if (action.getCluster() != null) {
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received config update from xDS client {0}: cluster_name={1}", XdsNameResolver.this.xdsClient, clusterName);
                    rawLbConfig = XdsNameResolver.generateCdsRawConfig(clusterName);
                } else {
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received config update with one weighted cluster route from xDS client {0}", XdsNameResolver.this.xdsClient);
                    List<EnvoyProtoData.ClusterWeight> clusterWeights = defaultRoute.getRouteAction().getWeightedCluster();
                    rawLbConfig = XdsNameResolver.generateWeightedTargetRawConfig(clusterWeights);
                }
            }
            ImmutableMap serviceConfig = ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of(rawLbConfig));
            if (XdsNameResolver.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Generated service config:\n{0}", new Gson().toJson((Object)serviceConfig));
            }
            Attributes attrs = Attributes.newBuilder().set(XdsAttributes.XDS_CLIENT_POOL, (Object)XdsNameResolver.this.xdsClientPool).build();
            NameResolver.ConfigOrError parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig((Map)serviceConfig);
            NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.of()).setAttributes(attrs).setServiceConfig(parsedServiceConfig).build();
            this.listener.onResult(result);
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
            NameResolver.ConfigOrError parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(Collections.emptyMap());
            NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(parsedServiceConfig).build();
            this.listener.onResult(result);
        }

        @Override
        public void onError(Status error) {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", XdsNameResolver.this.xdsClient, error.getDescription());
            this.listener.onError(error);
        }
    }
}

