/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsServerSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeServerSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.io.IOException;
import java.util.concurrent.Executors;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    ServerSslContextProviderFactory() {
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkNotNull((Object)downstreamTlsContext.getCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(downstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeServerSslContextProvider.getProvider(downstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(downstreamTlsContext.getCommonTlsContext())) {
            try {
                return SdsServerSslContextProvider.getProvider(downstreamTlsContext, Bootstrapper.getInstance().readBootstrap().getNode(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new UnsupportedOperationException("DownstreamTlsContext to have all filenames or all SdsConfig");
    }
}

