/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.Closeable;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContextProvider
implements Closeable {
    private static final Logger logger = Logger.getLogger(SslContextProvider.class.getName());
    protected final EnvoyServerProtoData.BaseTlsContext tlsContext;

    SslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext) {
        this.tlsContext = (EnvoyServerProtoData.BaseTlsContext)Preconditions.checkNotNull((Object)tlsContext, (Object)"tlsContext");
    }

    CommonTlsContext getCommonTlsContext() {
        return this.tlsContext.getCommonTlsContext();
    }

    protected void setClientAuthValues(SslContextBuilder sslContextBuilder, CertificateValidationContext localCertValidationContext) throws CertificateException, IOException, CertStoreException {
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = this.getDownstreamTlsContext();
        if (localCertValidationContext != null) {
            sslContextBuilder.trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(localCertValidationContext)));
            sslContextBuilder.clientAuth(downstreamTlsContext.isRequireClientCertificate() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext() {
        Preconditions.checkState((boolean)(this.tlsContext instanceof EnvoyServerProtoData.DownstreamTlsContext), (Object)"expected DownstreamTlsContext");
        return (EnvoyServerProtoData.DownstreamTlsContext)this.tlsContext;
    }

    public EnvoyServerProtoData.UpstreamTlsContext getUpstreamTlsContext() {
        Preconditions.checkState((boolean)(this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext), (Object)"expected UpstreamTlsContext");
        return (EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext;
    }

    @Override
    public abstract void close();

    public abstract void addCallback(Callback var1, Executor var2);

    final void performCallback(final SslContextGetter sslContextGetter, final Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)sslContextGetter, (Object)"sslContextGetter");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SslContext sslContext = sslContextGetter.get();
                    try {
                        callback.updateSecret(sslContext);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Exception from callback.updateSecret", t);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Exception from sslContextGetter.get()", e);
                    callback.onException(e);
                }
            }
        });
    }

    protected static interface SslContextGetter {
        public SslContext get() throws Exception;
    }

    public static interface Callback {
        public void updateSecret(SslContext var1);

        public void onException(Throwable var1);
    }
}

