/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class EventSummary {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="first")
    private String first;
    @JsonProperty(value="last")
    private String last;
    @JsonProperty(value="count")
    private int count;
    @JsonProperty(value="description")
    private String description;

    public String getName() {
        return this.name;
    }

    public String getFirstOccurredAtString() {
        return this.first;
    }

    public Date getFirstOccurredAt() throws ParseException {
        return this.stringToDate(this.first);
    }

    public String getLastOccurredAtString() {
        return this.last;
    }

    public Date getLastOccurredAt() throws ParseException {
        return this.stringToDate(this.last);
    }

    public int getCount() {
        return this.count;
    }

    public String getDescription() {
        return this.description;
    }

    private Date stringToDate(String dateString) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(dateString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSummary eventSummary = (EventSummary)o;
        if (this.name != null ? !this.name.equals(eventSummary.name) : eventSummary.name != null) {
            return false;
        }
        if (this.first != null ? !this.first.equals(eventSummary.first) : eventSummary.first != null) {
            return false;
        }
        if (this.last != null ? !this.last.equals(eventSummary.last) : eventSummary.last != null) {
            return false;
        }
        if (this.count != eventSummary.count) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(eventSummary.description) : eventSummary.description != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.first != null ? this.first.hashCode() : 0);
        result = 31 * result + (this.last != null ? this.last.hashCode() : 0);
        result = 31 * result + this.count;
        return result;
    }

    public String toString() {
        return "EventSummaryCollection{name='" + this.name + '\'' + ", count=" + this.count + ", description='" + this.description + '\'' + ", first='" + this.first + '\'' + ", last='" + this.last + '\'' + "} " + super.toString();
    }
}

