/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.NotificationCollection;
import io.intercom.api.NotificationErrorCollection;
import io.intercom.api.SubscriptionCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Subscription
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "notification_subscription";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="service_type")
    private final String serviceType = "web";
    @JsonProperty(value="app_id")
    private String appID;
    @JsonProperty(value="url")
    private URI url;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="topics")
    private List<Topic> topics = Lists.newArrayList();
    @JsonProperty(value="metadata")
    private Map<String, ArrayList<String>> metadata = Maps.newHashMap();
    @JsonProperty(value="active")
    private boolean active;
    @JsonProperty(value="hub_secret")
    private String hubSecret;
    @JsonProperty(value="mode")
    private String mode = "point";
    @JsonProperty(value="links")
    private Map<String, URI> links = Maps.newHashMap();
    @JsonProperty(value="notes")
    private List<String> notes = Lists.newArrayList();

    public static Subscription create(Subscription subscription) throws InvalidException, AuthorizationException {
        return DataResource.create(subscription, "subscriptions", Subscription.class);
    }

    public static Subscription update(Subscription subscription) throws InvalidException, AuthorizationException {
        return DataResource.update(subscription, "subscriptions", subscription.getId(), Subscription.class);
    }

    public static Subscription delete(Subscription subscription) throws InvalidException, AuthorizationException {
        return DataResource.delete(subscription.getId(), "subscriptions", Subscription.class);
    }

    public static Subscription find(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("subscriptions").path(id).build());
        return resource.get(Subscription.class);
    }

    public static SubscriptionCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "subscriptions", SubscriptionCollection.class);
    }

    public static Subscription ping(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("subscriptions").path(id).path("ping").build());
        return resource.post(Subscription.class, null);
    }

    public static Subscription ping(Subscription subscription) throws InvalidException, AuthorizationException {
        return Subscription.ping(subscription.getId());
    }

    public static NotificationCollection sentFeed(String id) throws InvalidException, AuthorizationException {
        URI feedURI = UriBuilder.newBuilder().path("subscriptions").path(id).path("sent").build();
        HttpClient resource = new HttpClient(feedURI);
        return resource.get(NotificationCollection.class);
    }

    public static NotificationErrorCollection errorFeed(String id) throws InvalidException, AuthorizationException {
        URI feedURI = UriBuilder.newBuilder().path("subscriptions").path(id).path("error").build();
        HttpClient resource = new HttpClient(feedURI);
        return resource.get(NotificationErrorCollection.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return "notification_subscription";
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getServiceType() {
        return "web";
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public URI getSelf() {
        return this.self;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public void setTopics(List<Topic> topics) {
        this.topics = topics;
    }

    public void addTopic(Topic topic) {
        this.topics.add(topic);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Map<String, ArrayList<String>> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, ArrayList<String>> metadata) {
        this.metadata = metadata;
    }

    public String getHubSecret() {
        return this.hubSecret;
    }

    public void setHubSecret(String hubSecret) {
        this.hubSecret = hubSecret;
    }

    public String getMode() {
        return this.mode;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    @JsonIgnore
    public String getURLString() {
        return this.url.toASCIIString();
    }

    @JsonIgnore
    public boolean requiresSignature() {
        return this.getHubSecret() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.active != that.active) {
            return false;
        }
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.updatedAt != that.updatedAt) {
            return false;
        }
        if (this.appID != null ? !this.appID.equals(that.appID) : that.appID != null) {
            return false;
        }
        if (this.hubSecret != null ? !this.hubSecret.equals(that.hubSecret) : that.hubSecret != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
            return false;
        }
        if (!"web".equals(that.serviceType)) {
            return false;
        }
        if (this.topics != null ? !this.topics.equals(that.topics) : that.topics != null) {
            return false;
        }
        if (!"notification_subscription".equals(that.type)) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = "notification_subscription".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + "web".hashCode();
        result = 31 * result + (this.appID != null ? this.appID.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
        result = 31 * result + (this.topics != null ? this.topics.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.hubSecret != null ? this.hubSecret.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Subscription{id='" + this.id + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", serviceType='" + "web" + '\'' + ", appID='" + this.appID + '\'' + ", url=" + this.url + ", self=" + this.self + ", topics=" + this.topics + ", metadata=" + this.metadata + ", active=" + this.active + ", hubSecret='" + this.hubSecret + '\'' + ", mode='" + this.mode + '\'' + ", links=" + this.links + ", notes=" + this.notes + "} " + super.toString();
    }

    public static class Topic {
        private static final String SUBTYPE_WILDCARD = "*";
        private static final String TEXT = "text";
        private static final String COMPANY_NAME = "company";
        private static final String CONVERSATION_NAME = "conversation";
        private static final String CONVERSATION_PART_NAME = "conversation_part";
        private static final String USER_NAME = "user";
        private static final String CONTACT_NAME = "contact";
        private static final String VISITOR_NAME = "visitor";
        private static final String EVENT_NAME = "event";
        public static final Topic PING = new Topic("ping", "*");
        public static final Topic COMPANY = new Topic("company", "*");
        public static final Topic COMPANY_CREATED = new Topic("company", "created");
        public static final Topic CONVERSATION = new Topic("conversation", "*");
        public static final Topic CONVERSATION_USER_CREATED = new Topic("conversation", "user.created");
        public static final Topic CONVERSATION_USER_REPLY = new Topic("conversation", "user.replied");
        public static final Topic CONVERSATION_ADMIN_REPLY = new Topic("conversation", "admin.replied");
        public static final Topic CONVERSATION_ADMIN_ASSIGNED = new Topic("conversation", "admin.assigned");
        public static final Topic CONVERSATION_ADMIN_CLOSED = new Topic("conversation", "admin.closed");
        public static final Topic CONVERSATION_ADMIN_OPEN = new Topic("conversation", "admin.opened");
        public static final Topic CONVERSATION_ADMIN_NOTED = new Topic("conversation", "admin.noted");
        public static final Topic CONVERSATION_ADMIN_SINGLE_CREATED = new Topic("conversation", "admin.single.created");
        public static final Topic CONVERSATION_PART_TAG_CREATED = new Topic("conversation_part", "tag.created");
        public static final Topic USER = new Topic("user", "*");
        public static final Topic USER_CREATED = new Topic("user", "created");
        public static final Topic USER_DELETED = new Topic("user", "deleted");
        public static final Topic USER_EMAIL_UPDATED = new Topic("user", "email.updated");
        public static final Topic USER_UNSUBSCRIBED = new Topic("user", "unsubscribed");
        public static final Topic USER_TAG_CREATED = new Topic("user", "tag.created");
        public static final Topic USER_TAG_DELETED = new Topic("user", "tag.deleted");
        public static final Topic CONTACT = new Topic("contact", "*");
        public static final Topic CONTACT_ADDED_EMAIL = new Topic("contact", "added_email");
        public static final Topic CONTACT_CREATED = new Topic("contact", "created");
        public static final Topic CONTACT_SIGNED_UP = new Topic("contact", "signed_up");
        public static final Topic VISITOR = new Topic("visitor", "*");
        public static final Topic VISITOR_SIGNED_UP = new Topic("visitor", "signed_up");
        public static final Topic EVENT_CREATED = new Topic("event", "created");
        public static final Topic ALL_TOPIC = Topic.valueOf("all");
        private String type;
        private String subType;
        private String toString;

        public static Topic valueOf(String type) throws IllegalArgumentException {
            if (type.contains(".")) {
                String[] split = type.split("\\.", 2);
                return new Topic(split[0], split[1]);
            }
            return new Topic(type);
        }

        public Topic(String type) {
            this(type, SUBTYPE_WILDCARD);
        }

        public Topic(String type, String subType) {
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type part cannot be null");
            Preconditions.checkArgument((subType != null ? 1 : 0) != 0, (Object)"subType part cannot be null");
            this.type = type;
            this.subType = subType;
            this.toString = SUBTYPE_WILDCARD.equals(subType) ? type : type + "." + subType;
        }

        public String getType() {
            return this.type;
        }

        public String getSubType() {
            return this.subType;
        }

        public boolean isCompatible(String type) {
            return this.isCompatible(Topic.valueOf(type));
        }

        public boolean isCompatible(Topic other) {
            if (other == null) {
                return false;
            }
            if (this.type.equalsIgnoreCase(other.type) && (this.subType.equals(SUBTYPE_WILDCARD) || other.subType.equals(SUBTYPE_WILDCARD))) {
                return true;
            }
            return this.type.equalsIgnoreCase(other.type) && this.subType.equalsIgnoreCase(other.subType);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Topic Topic2 = (Topic)o;
            if (this.subType != null ? !this.subType.equals(Topic2.subType) : Topic2.subType != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(Topic2.type) : Topic2.type != null);
        }
    }
}

