/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1ClusterCIDRSpec;
import io.kubernetes.client.openapi.models.V1alpha1ClusterCIDRSpecFluent;
import java.util.Objects;

public class V1alpha1ClusterCIDRSpecFluentImpl<A extends V1alpha1ClusterCIDRSpecFluent<A>>
extends BaseFluent<A>
implements V1alpha1ClusterCIDRSpecFluent<A> {
    private String ipv4;
    private String ipv6;
    private V1NodeSelectorBuilder nodeSelector;
    private Integer perNodeHostBits;

    public V1alpha1ClusterCIDRSpecFluentImpl() {
    }

    public V1alpha1ClusterCIDRSpecFluentImpl(V1alpha1ClusterCIDRSpec instance) {
        this.withIpv4(instance.getIpv4());
        this.withIpv6(instance.getIpv6());
        this.withNodeSelector(instance.getNodeSelector());
        this.withPerNodeHostBits(instance.getPerNodeHostBits());
    }

    @Override
    public String getIpv4() {
        return this.ipv4;
    }

    @Override
    public A withIpv4(String ipv4) {
        this.ipv4 = ipv4;
        return (A)this;
    }

    @Override
    public Boolean hasIpv4() {
        return this.ipv4 != null;
    }

    @Override
    public String getIpv6() {
        return this.ipv6;
    }

    @Override
    public A withIpv6(String ipv6) {
        this.ipv6 = ipv6;
        return (A)this;
    }

    @Override
    public Boolean hasIpv6() {
        return this.ipv6 != null;
    }

    @Override
    @Deprecated
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    @Override
    public V1NodeSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    @Override
    public A withNodeSelector(V1NodeSelector nodeSelector) {
        this._visitables.get("nodeSelector").remove(this.nodeSelector);
        if (nodeSelector != null) {
            this.nodeSelector = new V1NodeSelectorBuilder(nodeSelector);
            this._visitables.get("nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get("nodeSelector").remove(this.nodeSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNestedImpl();
    }

    @Override
    public V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<A> withNewNodeSelectorLike(V1NodeSelector item) {
        return new NodeSelectorNestedImpl(item);
    }

    @Override
    public V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(this.getNodeSelector());
    }

    @Override
    public V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(this.getNodeSelector() != null ? this.getNodeSelector() : new V1NodeSelectorBuilder().build());
    }

    @Override
    public V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<A> editOrNewNodeSelectorLike(V1NodeSelector item) {
        return this.withNewNodeSelectorLike(this.getNodeSelector() != null ? this.getNodeSelector() : item);
    }

    @Override
    public Integer getPerNodeHostBits() {
        return this.perNodeHostBits;
    }

    @Override
    public A withPerNodeHostBits(Integer perNodeHostBits) {
        this.perNodeHostBits = perNodeHostBits;
        return (A)this;
    }

    @Override
    public Boolean hasPerNodeHostBits() {
        return this.perNodeHostBits != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterCIDRSpecFluentImpl that = (V1alpha1ClusterCIDRSpecFluentImpl)o;
        if (this.ipv4 != null ? !this.ipv4.equals(that.ipv4) : that.ipv4 != null) {
            return false;
        }
        if (this.ipv6 != null ? !this.ipv6.equals(that.ipv6) : that.ipv6 != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        return !(this.perNodeHostBits != null ? !this.perNodeHostBits.equals(that.perNodeHostBits) : that.perNodeHostBits != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ipv4, this.ipv6, this.nodeSelector, this.perNodeHostBits, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipv4 != null) {
            sb.append("ipv4:");
            sb.append(this.ipv4 + ",");
        }
        if (this.ipv6 != null) {
            sb.append("ipv6:");
            sb.append(this.ipv6 + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.perNodeHostBits != null) {
            sb.append("perNodeHostBits:");
            sb.append(this.perNodeHostBits);
        }
        sb.append("}");
        return sb.toString();
    }

    class NodeSelectorNestedImpl<N>
    extends V1NodeSelectorFluentImpl<V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<N>>
    implements V1alpha1ClusterCIDRSpecFluent.NodeSelectorNested<N>,
    Nested<N> {
        V1NodeSelectorBuilder builder;

        NodeSelectorNestedImpl(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        NodeSelectorNestedImpl() {
            this.builder = new V1NodeSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ClusterCIDRSpecFluentImpl.this.withNodeSelector(this.builder.build());
        }

        @Override
        public N endNodeSelector() {
            return this.and();
        }
    }
}

