/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionFluent;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatus;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatusBuilder;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatusFluentImpl;
import java.util.Objects;

public class V1alpha1StorageVersionFluentImpl<A extends V1alpha1StorageVersionFluent<A>>
extends BaseFluent<A>
implements V1alpha1StorageVersionFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Object spec;
    private V1alpha1StorageVersionStatusBuilder status;

    public V1alpha1StorageVersionFluentImpl() {
    }

    public V1alpha1StorageVersionFluentImpl(V1alpha1StorageVersion instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha1StorageVersionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha1StorageVersionFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha1StorageVersionFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha1StorageVersionFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1alpha1StorageVersionFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Object getSpec() {
        return this.spec;
    }

    @Override
    public A withSpec(Object spec) {
        this.spec = spec;
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    @Deprecated
    public V1alpha1StorageVersionStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1alpha1StorageVersionStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1alpha1StorageVersionStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1alpha1StorageVersionStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1alpha1StorageVersionFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1alpha1StorageVersionFluent.StatusNested<A> withNewStatusLike(V1alpha1StorageVersionStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1alpha1StorageVersionFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1alpha1StorageVersionFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1alpha1StorageVersionStatusBuilder().build());
    }

    @Override
    public V1alpha1StorageVersionFluent.StatusNested<A> editOrNewStatusLike(V1alpha1StorageVersionStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1StorageVersionFluentImpl that = (V1alpha1StorageVersionFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1alpha1StorageVersionFluent.MetadataNested<N>>
    implements V1alpha1StorageVersionFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class StatusNestedImpl<N>
    extends V1alpha1StorageVersionStatusFluentImpl<V1alpha1StorageVersionFluent.StatusNested<N>>
    implements V1alpha1StorageVersionFluent.StatusNested<N>,
    Nested<N> {
        V1alpha1StorageVersionStatusBuilder builder;

        StatusNestedImpl(V1alpha1StorageVersionStatus item) {
            this.builder = new V1alpha1StorageVersionStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1alpha1StorageVersionStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }
}

