/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerCondition;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerConditionBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerConditionFluentImpl;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatus;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatusFluent;
import io.kubernetes.client.openapi.models.V2MetricStatus;
import io.kubernetes.client.openapi.models.V2MetricStatusBuilder;
import io.kubernetes.client.openapi.models.V2MetricStatusFluentImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2HorizontalPodAutoscalerStatusFluentImpl<A extends V2HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A>
implements V2HorizontalPodAutoscalerStatusFluent<A> {
    private ArrayList<V2HorizontalPodAutoscalerConditionBuilder> conditions;
    private ArrayList<V2MetricStatusBuilder> currentMetrics;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private OffsetDateTime lastScaleTime;
    private Long observedGeneration;

    public V2HorizontalPodAutoscalerStatusFluentImpl() {
    }

    public V2HorizontalPodAutoscalerStatusFluentImpl(V2HorizontalPodAutoscalerStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentMetrics(instance.getCurrentMetrics());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public A addToConditions(Integer index, V2HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, V2HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V2HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V2HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V2HorizontalPodAutoscalerCondition ... items) {
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V2HorizontalPodAutoscalerCondition> items) {
        for (V2HorizontalPodAutoscalerCondition item : items) {
            V2HorizontalPodAutoscalerConditionBuilder builder = new V2HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V2HorizontalPodAutoscalerConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V2HorizontalPodAutoscalerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V2HorizontalPodAutoscalerCondition> getConditions() {
        return this.conditions != null ? V2HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V2HorizontalPodAutoscalerCondition> buildConditions() {
        return this.conditions != null ? V2HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V2HorizontalPodAutoscalerCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V2HorizontalPodAutoscalerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V2HorizontalPodAutoscalerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V2HorizontalPodAutoscalerCondition buildMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (V2HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (V2HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V2HorizontalPodAutoscalerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V2HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V2HorizontalPodAutoscalerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V2HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(V2HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, V2HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V2HorizontalPodAutoscalerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToCurrentMetrics(Integer index, V2MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
        this._visitables.get("currentMetrics").add(index >= 0 ? index.intValue() : this._visitables.get("currentMetrics").size(), builder);
        this.currentMetrics.add(index >= 0 ? index.intValue() : this.currentMetrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCurrentMetrics(Integer index, V2MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("currentMetrics").size()) {
            this._visitables.get("currentMetrics").add(builder);
        } else {
            this._visitables.get("currentMetrics").set(index, builder);
        }
        if (index < 0 || index >= this.currentMetrics.size()) {
            this.currentMetrics.add(builder);
        } else {
            this.currentMetrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCurrentMetrics(V2MetricStatus ... items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCurrentMetrics(Collection<V2MetricStatus> items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCurrentMetrics(V2MetricStatus ... items) {
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCurrentMetrics(Collection<V2MetricStatus> items) {
        for (V2MetricStatus item : items) {
            V2MetricStatusBuilder builder = new V2MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCurrentMetrics(Predicate<V2MetricStatusBuilder> predicate) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        Iterator<V2MetricStatusBuilder> each = this.currentMetrics.iterator();
        Object visitables = this._visitables.get("currentMetrics");
        while (each.hasNext()) {
            V2MetricStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V2MetricStatus> getCurrentMetrics() {
        return this.currentMetrics != null ? V2HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics) : null;
    }

    @Override
    public List<V2MetricStatus> buildCurrentMetrics() {
        return this.currentMetrics != null ? V2HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics) : null;
    }

    @Override
    public V2MetricStatus buildCurrentMetric(Integer index) {
        return this.currentMetrics.get(index).build();
    }

    @Override
    public V2MetricStatus buildFirstCurrentMetric() {
        return this.currentMetrics.get(0).build();
    }

    @Override
    public V2MetricStatus buildLastCurrentMetric() {
        return this.currentMetrics.get(this.currentMetrics.size() - 1).build();
    }

    @Override
    public V2MetricStatus buildMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        for (V2MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        for (V2MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCurrentMetrics(List<V2MetricStatus> currentMetrics) {
        if (this.currentMetrics != null) {
            this._visitables.get("currentMetrics").removeAll(this.currentMetrics);
        }
        if (currentMetrics != null) {
            this.currentMetrics = new ArrayList();
            for (V2MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        } else {
            this.currentMetrics = null;
        }
        return (A)this;
    }

    @Override
    public A withCurrentMetrics(V2MetricStatus ... currentMetrics) {
        if (this.currentMetrics != null) {
            this.currentMetrics.clear();
        }
        if (currentMetrics != null) {
            for (V2MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentMetrics() {
        return this.currentMetrics != null && !this.currentMetrics.isEmpty();
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetric() {
        return new CurrentMetricsNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetricLike(V2MetricStatus item) {
        return new CurrentMetricsNestedImpl(-1, item);
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> setNewCurrentMetricLike(Integer index, V2MetricStatus item) {
        return new CurrentMetricsNestedImpl(index, item);
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editCurrentMetric(Integer index) {
        if (this.currentMetrics.size() <= index) {
            throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editFirstCurrentMetric() {
        if (this.currentMetrics.size() == 0) {
            throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(0, this.buildCurrentMetric(0));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editLastCurrentMetric() {
        int index = this.currentMetrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editMatchingCurrentMetric(Predicate<V2MetricStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentMetrics.size(); ++i) {
            if (!predicate.test(this.currentMetrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    @Override
    public A withLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerStatusFluentImpl that = (V2HorizontalPodAutoscalerStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentMetrics != null ? !this.currentMetrics.equals(that.currentMetrics) : that.currentMetrics != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.desiredReplicas != null ? !this.desiredReplicas.equals(that.desiredReplicas) : that.desiredReplicas != null) {
            return false;
        }
        if (this.lastScaleTime != null ? !this.lastScaleTime.equals(that.lastScaleTime) : that.lastScaleTime != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentMetrics != null && !this.currentMetrics.isEmpty()) {
            sb.append("currentMetrics:");
            sb.append(this.currentMetrics + ",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V2HorizontalPodAutoscalerConditionFluentImpl<V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>>
    implements V2HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V2HorizontalPodAutoscalerConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, V2HorizontalPodAutoscalerCondition item) {
            this.index = index;
            this.builder = new V2HorizontalPodAutoscalerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V2HorizontalPodAutoscalerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class CurrentMetricsNestedImpl<N>
    extends V2MetricStatusFluentImpl<V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>>
    implements V2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>,
    Nested<N> {
        V2MetricStatusBuilder builder;
        Integer index;

        CurrentMetricsNestedImpl(Integer index, V2MetricStatus item) {
            this.index = index;
            this.builder = new V2MetricStatusBuilder(this, item);
        }

        CurrentMetricsNestedImpl() {
            this.index = -1;
            this.builder = new V2MetricStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerStatusFluentImpl.this.setToCurrentMetrics(this.index, this.builder.build());
        }

        @Override
        public N endCurrentMetric() {
            return this.and();
        }
    }
}

