/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1AppArmorProfile;
import io.kubernetes.client.openapi.models.V1Capabilities;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1SecurityContext {
    public static final String SERIALIZED_NAME_ALLOW_PRIVILEGE_ESCALATION = "allowPrivilegeEscalation";
    @SerializedName(value="allowPrivilegeEscalation")
    private Boolean allowPrivilegeEscalation;
    public static final String SERIALIZED_NAME_APP_ARMOR_PROFILE = "appArmorProfile";
    @SerializedName(value="appArmorProfile")
    private V1AppArmorProfile appArmorProfile;
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private V1Capabilities capabilities;
    public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
    @SerializedName(value="privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_PROC_MOUNT = "procMount";
    @SerializedName(value="procMount")
    private String procMount;
    public static final String SERIALIZED_NAME_READ_ONLY_ROOT_FILESYSTEM = "readOnlyRootFilesystem";
    @SerializedName(value="readOnlyRootFilesystem")
    private Boolean readOnlyRootFilesystem;
    public static final String SERIALIZED_NAME_RUN_AS_GROUP = "runAsGroup";
    @SerializedName(value="runAsGroup")
    private Long runAsGroup;
    public static final String SERIALIZED_NAME_RUN_AS_NON_ROOT = "runAsNonRoot";
    @SerializedName(value="runAsNonRoot")
    private Boolean runAsNonRoot;
    public static final String SERIALIZED_NAME_RUN_AS_USER = "runAsUser";
    @SerializedName(value="runAsUser")
    private Long runAsUser;
    public static final String SERIALIZED_NAME_SE_LINUX_OPTIONS = "seLinuxOptions";
    @SerializedName(value="seLinuxOptions")
    private V1SELinuxOptions seLinuxOptions;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE = "seccompProfile";
    @SerializedName(value="seccompProfile")
    private V1SeccompProfile seccompProfile;
    public static final String SERIALIZED_NAME_WINDOWS_OPTIONS = "windowsOptions";
    @SerializedName(value="windowsOptions")
    private V1WindowsSecurityContextOptions windowsOptions;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1SecurityContext allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    @Nullable
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public V1SecurityContext appArmorProfile(V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
        return this;
    }

    @Nullable
    public V1AppArmorProfile getAppArmorProfile() {
        return this.appArmorProfile;
    }

    public void setAppArmorProfile(V1AppArmorProfile appArmorProfile) {
        this.appArmorProfile = appArmorProfile;
    }

    public V1SecurityContext capabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Nullable
    public V1Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public V1SecurityContext privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public V1SecurityContext procMount(String procMount) {
        this.procMount = procMount;
        return this;
    }

    @Nullable
    public String getProcMount() {
        return this.procMount;
    }

    public void setProcMount(String procMount) {
        this.procMount = procMount;
    }

    public V1SecurityContext readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    @Nullable
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public V1SecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public V1SecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1SecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1SecurityContext seLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public V1SecurityContext seccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    @Nullable
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public V1SecurityContext windowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecurityContext v1SecurityContext = (V1SecurityContext)o;
        return Objects.equals(this.allowPrivilegeEscalation, v1SecurityContext.allowPrivilegeEscalation) && Objects.equals(this.appArmorProfile, v1SecurityContext.appArmorProfile) && Objects.equals(this.capabilities, v1SecurityContext.capabilities) && Objects.equals(this.privileged, v1SecurityContext.privileged) && Objects.equals(this.procMount, v1SecurityContext.procMount) && Objects.equals(this.readOnlyRootFilesystem, v1SecurityContext.readOnlyRootFilesystem) && Objects.equals(this.runAsGroup, v1SecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, v1SecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1SecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, v1SecurityContext.seLinuxOptions) && Objects.equals(this.seccompProfile, v1SecurityContext.seccompProfile) && Objects.equals(this.windowsOptions, v1SecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.appArmorProfile, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecurityContext {\n");
        sb.append("    allowPrivilegeEscalation: ").append(this.toIndentedString(this.allowPrivilegeEscalation)).append("\n");
        sb.append("    appArmorProfile: ").append(this.toIndentedString(this.appArmorProfile)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    procMount: ").append(this.toIndentedString(this.procMount)).append("\n");
        sb.append("    readOnlyRootFilesystem: ").append(this.toIndentedString(this.readOnlyRootFilesystem)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    seccompProfile: ").append(this.toIndentedString(this.seccompProfile)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1SecurityContext is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1SecurityContext` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE).isJsonNull()) {
            V1AppArmorProfile.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APP_ARMOR_PROFILE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITIES) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonNull()) {
            V1Capabilities.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CAPABILITIES));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROC_MOUNT) != null && !jsonObj.get(SERIALIZED_NAME_PROC_MOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROC_MOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `procMount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROC_MOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS).isJsonNull()) {
            V1SELinuxOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE).isJsonNull()) {
            V1SeccompProfile.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE));
        }
        if (jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS).isJsonNull()) {
            V1WindowsSecurityContextOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS));
        }
    }

    public static V1SecurityContext fromJson(String jsonString) throws IOException {
        return (V1SecurityContext)JSON.getGson().fromJson(jsonString, V1SecurityContext.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOW_PRIVILEGE_ESCALATION);
        openapiFields.add(SERIALIZED_NAME_APP_ARMOR_PROFILE);
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGED);
        openapiFields.add(SERIALIZED_NAME_PROC_MOUNT);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY_ROOT_FILESYSTEM);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_GROUP);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_NON_ROOT);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_USER);
        openapiFields.add(SERIALIZED_NAME_SE_LINUX_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_PROFILE);
        openapiFields.add(SERIALIZED_NAME_WINDOWS_OPTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1SecurityContext.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1SecurityContext.class));
            return new TypeAdapter<V1SecurityContext>(){

                public void write(JsonWriter out, V1SecurityContext value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1SecurityContext read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1SecurityContext.validateJsonElement(jsonElement);
                    return (V1SecurityContext)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

