/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisURI;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.masterslave.RefreshFutures;
import io.lettuce.core.masterslave.TimedAsyncCommand;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

class Requests {
    private final Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(MasterSlaveUtils.RedisURIComparator.INSTANCE);

    protected void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
    }

    protected long await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return RefreshFutures.awaitAll(timeout, timeUnit, this.rawViews.values());
    }

    protected Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    protected TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }
}

