/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisException;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.Channel;
import io.netty.util.internal.ConcurrentSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class PubSubEndpoint<K, V>
extends DefaultEndpoint {
    private static final Set<String> ALLOWED_COMMANDS_SUBSCRIBED = new HashSet<String>(5, 1.0f);
    private static final Set<String> SUBSCRIBE_COMMANDS;
    private final List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    private final Set<K> channels = new ConcurrentSet();
    private final Set<K> patterns = new ConcurrentSet();
    private volatile boolean subscribeWritten = false;

    public PubSubEndpoint(ClientOptions clientOptions, ClientResources clientResources) {
        super(clientOptions, clientResources);
    }

    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    protected List<RedisPubSubListener<K, V>> getListeners() {
        return this.listeners;
    }

    public Set<K> getChannels() {
        return this.channels;
    }

    public Set<K> getPatterns() {
        return this.patterns;
    }

    @Override
    public void notifyChannelActive(Channel channel) {
        this.subscribeWritten = false;
        super.notifyChannelActive(channel);
    }

    public <K1, V1, T> RedisCommand<K1, V1, T> write(RedisCommand<K1, V1, T> command) {
        if (this.isSubscribed()) {
            PubSubEndpoint.validateCommandAllowed(command);
        }
        if (!this.subscribeWritten && SUBSCRIBE_COMMANDS.contains(command.getType().name())) {
            this.subscribeWritten = true;
        }
        return super.write(command);
    }

    public <K1, V1> Collection<RedisCommand<K1, V1, ?>> write(Collection<? extends RedisCommand<K1, V1, ?>> redisCommands) {
        if (this.isSubscribed()) {
            redisCommands.forEach(PubSubEndpoint::validateCommandAllowed);
        }
        if (!this.subscribeWritten) {
            for (RedisCommand<K1, V1, ?> redisCommand : redisCommands) {
                if (!SUBSCRIBE_COMMANDS.contains(redisCommand.getType().name())) continue;
                this.subscribeWritten = true;
                break;
            }
        }
        return super.write(redisCommands);
    }

    private static void validateCommandAllowed(RedisCommand<?, ?, ?> command) {
        if (!ALLOWED_COMMANDS_SUBSCRIBED.contains(command.getType().name())) {
            throw new RedisException(String.format("Command %s not allowed while subscribed. Allowed commands are: %s", command.getType().name(), ALLOWED_COMMANDS_SUBSCRIBED));
        }
    }

    private boolean isSubscribed() {
        return this.subscribeWritten && (!this.channels.isEmpty() || !this.patterns.isEmpty());
    }

    public void notifyMessage(PubSubOutput<K, V, V> output) {
        if (output.type() == null || output.pattern() == null && output.channel() == null && output.get() == null) {
            return;
        }
        this.updateInternalState(output);
        this.notifyListeners(output);
    }

    protected void notifyListeners(PubSubOutput<K, V, V> output) {
        block8: for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    continue block8;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    continue block8;
                }
                case psubscribe: {
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case punsubscribe: {
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case subscribe: {
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    continue block8;
                }
                case unsubscribe: {
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
        }
    }

    private void updateInternalState(PubSubOutput<K, V, V> output) {
        switch (output.type()) {
            case psubscribe: {
                this.patterns.add(output.pattern());
                break;
            }
            case punsubscribe: {
                this.patterns.remove(output.pattern());
                break;
            }
            case subscribe: {
                this.channels.add(output.channel());
                break;
            }
            case unsubscribe: {
                this.channels.remove(output.channel());
                break;
            }
        }
    }

    static {
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.SUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.PSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.UNSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.PUNSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.QUIT.name());
        SUBSCRIBE_COMMANDS = new HashSet<String>(2, 1.0f);
        SUBSCRIBE_COMMANDS.add(CommandType.SUBSCRIBE.name());
        SUBSCRIBE_COMMANDS.add(CommandType.PSUBSCRIBE.name());
    }
}

