/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.AbstractRedisReactiveCommands;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.dynamic.AsyncExecutableCommandLookupStrategy;
import io.lettuce.core.dynamic.BatchExecutableCommandLookupStrategy;
import io.lettuce.core.dynamic.Batcher;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.CommandMethodVerifier;
import io.lettuce.core.dynamic.Commands;
import io.lettuce.core.dynamic.DeclaredCommandMethod;
import io.lettuce.core.dynamic.DefaultCommandMethodVerifier;
import io.lettuce.core.dynamic.DefaultRedisCommandsMetadata;
import io.lettuce.core.dynamic.ExecutableCommand;
import io.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import io.lettuce.core.dynamic.ReactiveExecutableCommandLookupStrategy;
import io.lettuce.core.dynamic.RedisCommandsMetadata;
import io.lettuce.core.dynamic.SimpleBatcher;
import io.lettuce.core.dynamic.batch.BatchSize;
import io.lettuce.core.dynamic.intercept.DefaultMethodInvokingInterceptor;
import io.lettuce.core.dynamic.intercept.InvocationProxyFactory;
import io.lettuce.core.dynamic.intercept.MethodInterceptor;
import io.lettuce.core.dynamic.intercept.MethodInvocation;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.output.OutputRegistry;
import io.lettuce.core.dynamic.output.OutputRegistryCommandOutputFactoryResolver;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.models.command.CommandDetail;
import io.lettuce.core.models.command.CommandDetailParser;
import io.lettuce.core.protocol.LettuceCharsets;
import io.lettuce.core.support.ConnectionWrapping;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisCommandFactory {
    private final InternalLogger log = InternalLoggerFactory.getInstance(this.getClass());
    private final StatefulConnection<?, ?> connection;
    private final DefaultCommandMethodVerifier commandMethodVerifier;
    private final List<RedisCodec<?, ?>> redisCodecs = new ArrayList();
    private CommandOutputFactoryResolver commandOutputFactoryResolver = new OutputRegistryCommandOutputFactoryResolver(new OutputRegistry());
    private boolean verifyCommandMethods = true;

    public RedisCommandFactory(StatefulConnection<?, ?> connection) {
        this(connection, LettuceLists.newList(new ByteArrayCodec(), new StringCodec(LettuceCharsets.UTF8)));
    }

    public RedisCommandFactory(StatefulConnection<?, ?> connection, Iterable<? extends RedisCodec<?, ?>> redisCodecs) {
        LettuceAssert.notNull(connection, "Redis Connection must not be null");
        LettuceAssert.notNull(redisCodecs, "Iterable of RedisCodec must not be null");
        this.connection = connection;
        this.redisCodecs.addAll(LettuceLists.newList(redisCodecs));
        this.commandMethodVerifier = new DefaultCommandMethodVerifier(this.getCommands(connection));
    }

    private List<CommandDetail> getCommands(StatefulConnection<?, ?> connection) {
        List<Object> commands = Collections.emptyList();
        try {
            if (connection instanceof StatefulRedisConnection) {
                commands = ((StatefulRedisConnection)connection).sync().command();
            }
            if (connection instanceof StatefulRedisClusterConnection) {
                commands = ((StatefulRedisClusterConnection)connection).sync().command();
            }
        }
        catch (RedisCommandExecutionException e) {
            this.log.debug("Cannot obtain command metadata", (Throwable)e);
        }
        if (commands.isEmpty()) {
            this.setVerifyCommandMethods(false);
        }
        return CommandDetailParser.parse(commands);
    }

    public void setCommandOutputFactoryResolver(CommandOutputFactoryResolver commandOutputFactoryResolver) {
        LettuceAssert.notNull((Object)commandOutputFactoryResolver, "CommandOutputFactoryResolver must not be null");
        this.commandOutputFactoryResolver = commandOutputFactoryResolver;
    }

    public void setVerifyCommandMethods(boolean verifyCommandMethods) {
        this.verifyCommandMethods = verifyCommandMethods;
    }

    public <T extends Commands> T getCommands(Class<T> commandInterface) {
        LettuceAssert.notNull(commandInterface, "Redis Command Interface must not be null");
        DefaultRedisCommandsMetadata metadata = new DefaultRedisCommandsMetadata(commandInterface);
        InvocationProxyFactory factory = new InvocationProxyFactory();
        factory.addInterface(commandInterface);
        BatchAwareCommandLookupStrategy lookupStrategy = new BatchAwareCommandLookupStrategy(new CompositeCommandLookupStrategy(), metadata);
        factory.addInterceptor(new DefaultMethodInvokingInterceptor());
        factory.addInterceptor(new CommandFactoryExecutorMethodInterceptor(metadata, lookupStrategy));
        return (T)((Commands)factory.createProxy(commandInterface.getClassLoader()));
    }

    class BatchAwareCommandLookupStrategy
    implements ExecutableCommandLookupStrategy {
        private final ExecutableCommandLookupStrategy fallbackStrategy;
        private final boolean globalBatching;
        private final CommandMethodVerifier verifier;
        private final long batchSize;
        private Batcher batcher = Batcher.NONE;
        private BatchExecutableCommandLookupStrategy batchingStrategy;

        public BatchAwareCommandLookupStrategy(ExecutableCommandLookupStrategy fallbackStrategy, RedisCommandsMetadata metadata) {
            this.fallbackStrategy = fallbackStrategy;
            CommandMethodVerifier commandMethodVerifier = this.verifier = RedisCommandFactory.this.verifyCommandMethods ? RedisCommandFactory.this.commandMethodVerifier : CommandMethodVerifier.NONE;
            if (metadata.hasAnnotation(BatchSize.class)) {
                BatchSize batchSize = metadata.getAnnotation(BatchSize.class);
                this.globalBatching = true;
                this.batchSize = batchSize.value();
            } else {
                this.globalBatching = false;
                this.batchSize = -1L;
            }
        }

        @Override
        public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata metadata) {
            if (BatchExecutableCommandLookupStrategy.supports(method) || this.globalBatching) {
                if (this.batcher == Batcher.NONE) {
                    this.batcher = new SimpleBatcher(RedisCommandFactory.this.connection, Math.toIntExact(this.batchSize));
                    this.batchingStrategy = new BatchExecutableCommandLookupStrategy(RedisCommandFactory.this.redisCodecs, RedisCommandFactory.this.commandOutputFactoryResolver, this.verifier, this.batcher, RedisCommandFactory.this.connection);
                }
                return this.batchingStrategy.resolveCommandMethod(method, metadata);
            }
            return this.fallbackStrategy.resolveCommandMethod(method, metadata);
        }
    }

    class CompositeCommandLookupStrategy
    implements ExecutableCommandLookupStrategy {
        private final AsyncExecutableCommandLookupStrategy async;
        private final ReactiveExecutableCommandLookupStrategy reactive;

        CompositeCommandLookupStrategy() {
            CommandMethodVerifier verifier = RedisCommandFactory.this.verifyCommandMethods ? RedisCommandFactory.this.commandMethodVerifier : CommandMethodVerifier.NONE;
            AbstractRedisReactiveCommands reactive = this.getReactiveCommands();
            LettuceAssert.isTrue(reactive != null, "Reactive commands is null");
            this.async = new AsyncExecutableCommandLookupStrategy(RedisCommandFactory.this.redisCodecs, RedisCommandFactory.this.commandOutputFactoryResolver, verifier, RedisCommandFactory.this.connection);
            this.reactive = new ReactiveExecutableCommandLookupStrategy(RedisCommandFactory.this.redisCodecs, RedisCommandFactory.this.commandOutputFactoryResolver, verifier, reactive);
        }

        private AbstractRedisReactiveCommands getReactiveCommands() {
            Object reactive = null;
            if (RedisCommandFactory.this.connection instanceof StatefulRedisConnection) {
                reactive = ((StatefulRedisConnection)RedisCommandFactory.this.connection).reactive();
            }
            if (RedisCommandFactory.this.connection instanceof StatefulRedisClusterConnection) {
                reactive = ((StatefulRedisClusterConnection)RedisCommandFactory.this.connection).reactive();
            }
            if (Proxy.isProxyClass(reactive.getClass())) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(reactive);
                reactive = ConnectionWrapping.unwrap(invocationHandler);
            }
            return (AbstractRedisReactiveCommands)reactive;
        }

        @Override
        public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata metadata) {
            if (method.isReactiveExecution()) {
                return this.reactive.resolveCommandMethod(method, metadata);
            }
            return this.async.resolveCommandMethod(method, metadata);
        }
    }

    static class CommandFactoryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, ExecutableCommand> commandMethods = new HashMap<Method, ExecutableCommand>();

        CommandFactoryExecutorMethodInterceptor(RedisCommandsMetadata redisCommandsMetadata, ExecutableCommandLookupStrategy strategy) {
            for (Method method : redisCommandsMetadata.getMethods()) {
                ExecutableCommand executableCommand = strategy.resolveCommandMethod(DeclaredCommandMethod.create(method), redisCommandsMetadata);
                this.commandMethods.put(method, executableCommand);
            }
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.hasFactoryFor(method)) {
                ExecutableCommand executableCommand = this.commandMethods.get(method);
                return executableCommand.execute(arguments);
            }
            return invocation.proceed();
        }

        private boolean hasFactoryFor(Method method) {
            return this.commandMethods.containsKey(method);
        }
    }
}

