/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.EpollProvider;
import io.lettuce.core.KqueueProvider;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.Futures;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultEventLoopGroupProvider
implements EventLoopGroupProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEventLoopGroupProvider.class);
    private final Map<Class<? extends EventExecutorGroup>, EventExecutorGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(2);
    private final Map<ExecutorService, Long> refCounter = new ConcurrentHashMap<ExecutorService, Long>(2);
    private final int numberOfThreads;
    private volatile boolean shutdownCalled = false;

    public DefaultEventLoopGroupProvider(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventLoopGroup> T allocate(Class<T> type) {
        DefaultEventLoopGroupProvider defaultEventLoopGroupProvider = this;
        synchronized (defaultEventLoopGroupProvider) {
            logger.debug("Allocating executor {}", (Object)type.getName());
            return (T)((EventLoopGroup)this.addReference(this.getOrCreate(type)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T addReference(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            logger.debug("Adding reference to {}, existing ref count {}", reference, (Object)counter);
            this.refCounter.put(reference, ++counter);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T release(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            if (counter < 1L) {
                logger.debug("Attempting to release {} but ref count is {}", reference, (Object)counter);
            }
            if (--counter == 0L) {
                this.refCounter.remove(reference);
            } else {
                this.refCounter.put(reference, counter);
            }
        }
        return reference;
    }

    private <T extends EventLoopGroup> T getOrCreate(Class<T> type) {
        if (this.shutdownCalled) {
            throw new IllegalStateException("Provider is shut down and can not longer provide resources");
        }
        if (!this.eventLoopGroups.containsKey(type)) {
            this.eventLoopGroups.put(type, DefaultEventLoopGroupProvider.createEventLoopGroup(type, this.numberOfThreads));
        }
        return (T)((EventLoopGroup)this.eventLoopGroups.get(type));
    }

    public static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads) {
        logger.debug("Creating executor {}", (Object)type.getName());
        if (DefaultEventExecutorGroup.class.equals(type)) {
            return new DefaultEventExecutorGroup(numberOfThreads, (ThreadFactory)new DefaultThreadFactory("lettuce-eventExecutorLoop", true));
        }
        if (NioEventLoopGroup.class.equals(type)) {
            return new NioEventLoopGroup(numberOfThreads, (ThreadFactory)new DefaultThreadFactory("lettuce-nioEventLoop", true));
        }
        if (EpollProvider.isAvailable() && EpollProvider.isEventLoopGroup(type)) {
            return EpollProvider.newEventLoopGroup(numberOfThreads, (ThreadFactory)new DefaultThreadFactory("lettuce-epollEventLoop", true));
        }
        if (KqueueProvider.isAvailable() && KqueueProvider.isEventLoopGroup(type)) {
            return KqueueProvider.newEventLoopGroup(numberOfThreads, (ThreadFactory)new DefaultThreadFactory("lettuce-kqueueEventLoop", true));
        }
        throw new IllegalArgumentException(String.format("Type %s not supported", type.getName()));
    }

    public Promise<Boolean> release(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        logger.debug("Release executor {}", (Object)eventLoopGroup);
        Class<?> key = this.getKey(this.release(eventLoopGroup));
        if (key == null && eventLoopGroup.isShuttingDown() || this.refCounter.containsKey(eventLoopGroup)) {
            DefaultPromise promise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            promise.setSuccess((Object)true);
            return promise;
        }
        if (key != null) {
            this.eventLoopGroups.remove(key);
        }
        Future shutdownFuture = eventLoopGroup.shutdownGracefully(quietPeriod, timeout, unit);
        return Futures.toBooleanPromise(shutdownFuture);
    }

    private Class<?> getKey(EventExecutorGroup eventLoopGroup) {
        Class key = null;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        for (Map.Entry entry : copy.entrySet()) {
            if (entry.getValue() != eventLoopGroup) continue;
            key = (Class)entry.getKey();
            break;
        }
        return key;
    }

    @Override
    public int threadPoolSize() {
        return this.numberOfThreads;
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
        this.shutdownCalled = true;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        DefaultPromise overall = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        DefaultPromise lastRelease = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        Futures.PromiseAggregator aggregator = new Futures.PromiseAggregator(overall);
        aggregator.expectMore(1 + copy.size());
        aggregator.arm();
        for (EventExecutorGroup executorGroup : copy.values()) {
            Promise<Boolean> shutdown = Futures.toBooleanPromise(this.release(executorGroup, quietPeriod, timeout, timeUnit));
            aggregator.add(shutdown);
        }
        aggregator.add(new Promise[]{lastRelease});
        lastRelease.setSuccess(null);
        return Futures.toBooleanPromise(overall);
    }
}

