/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.partitions;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterPartitionParser {
    public static final String CONNECTED = "connected";
    private static final String TOKEN_SLOT_IN_TRANSITION = "[";
    private static final char TOKEN_NODE_SEPARATOR = '\n';
    private static final Map<String, RedisClusterNode.NodeFlag> FLAG_MAPPING;

    private ClusterPartitionParser() {
    }

    public static Partitions parse(String nodes) {
        Partitions result = new Partitions();
        try {
            String[] lines = nodes.split(Character.toString('\n'));
            ArrayList<RedisClusterNode> mappedNodes = new ArrayList<RedisClusterNode>(lines.length);
            for (String line : lines) {
                if (line.isEmpty()) continue;
                mappedNodes.add(ClusterPartitionParser.parseNode(line));
            }
            result.addAll((Collection<? extends RedisClusterNode>)mappedNodes);
        }
        catch (Exception e) {
            throw new RedisException("Cannot parse " + nodes, e);
        }
        return result;
    }

    private static RedisClusterNode parseNode(String nodeInformation) {
        HostAndPort hostAndPort;
        Iterator<String> iterator = Arrays.asList(nodeInformation.split(" ")).iterator();
        String nodeId = iterator.next();
        boolean connected = false;
        RedisURI uri = null;
        String hostAndPortPart = iterator.next();
        if (hostAndPortPart.contains("@")) {
            hostAndPortPart = hostAndPortPart.substring(0, hostAndPortPart.indexOf(64));
        }
        if (LettuceStrings.isNotEmpty((hostAndPort = HostAndPort.parseCompat(hostAndPortPart)).getHostText())) {
            uri = RedisURI.Builder.redis(hostAndPort.getHostText(), hostAndPort.getPort()).build();
        }
        String flags = iterator.next();
        List<String> flagStrings = LettuceLists.newList(flags.split("\\,"));
        Set<RedisClusterNode.NodeFlag> nodeFlags = ClusterPartitionParser.readFlags(flagStrings);
        String replicaOfString = iterator.next();
        String replicaOf = "-".equals(replicaOfString) ? null : replicaOfString;
        long pingSentTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long pongReceivedTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long configEpoch = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        String connectedFlags = iterator.next();
        if (CONNECTED.equals(connectedFlags)) {
            connected = true;
        }
        List<String> slotStrings = LettuceLists.newList(iterator);
        BitSet slots = ClusterPartitionParser.readSlots(slotStrings);
        RedisClusterNode partition = new RedisClusterNode(uri, nodeId, connected, replicaOf, pingSentTs, pongReceivedTs, configEpoch, slots, nodeFlags);
        return partition;
    }

    private static Set<RedisClusterNode.NodeFlag> readFlags(List<String> flagStrings) {
        HashSet<RedisClusterNode.NodeFlag> flags = new HashSet<RedisClusterNode.NodeFlag>();
        for (String flagString : flagStrings) {
            if (!FLAG_MAPPING.containsKey(flagString)) continue;
            flags.add(FLAG_MAPPING.get(flagString));
        }
        if (flags.contains((Object)RedisClusterNode.NodeFlag.SLAVE)) {
            flags.add(RedisClusterNode.NodeFlag.REPLICA);
        }
        return Collections.unmodifiableSet(flags);
    }

    private static BitSet readSlots(List<String> slotStrings) {
        BitSet slots = new BitSet(16384);
        for (String slotString : slotStrings) {
            if (slotString.startsWith(TOKEN_SLOT_IN_TRANSITION)) continue;
            if (slotString.contains("-")) {
                Iterator<String> it = Arrays.asList(slotString.split("\\-")).iterator();
                int from = Integer.parseInt(it.next());
                int to = Integer.parseInt(it.next());
                for (int slot = from; slot <= to; ++slot) {
                    slots.set(slot);
                }
                continue;
            }
            slots.set(Integer.parseInt(slotString));
        }
        return slots;
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return Long.parseLong((String)object);
        }
        return defaultValue;
    }

    static {
        HashMap<String, RedisClusterNode.NodeFlag> map = new HashMap<String, RedisClusterNode.NodeFlag>();
        map.put("noflags", RedisClusterNode.NodeFlag.NOFLAGS);
        map.put("myself", RedisClusterNode.NodeFlag.MYSELF);
        map.put("master", RedisClusterNode.NodeFlag.MASTER);
        map.put("slave", RedisClusterNode.NodeFlag.SLAVE);
        map.put("replica", RedisClusterNode.NodeFlag.REPLICA);
        map.put("fail?", RedisClusterNode.NodeFlag.EVENTUAL_FAIL);
        map.put("fail", RedisClusterNode.NodeFlag.FAIL);
        map.put("handshake", RedisClusterNode.NodeFlag.HANDSHAKE);
        map.put("noaddr", RedisClusterNode.NodeFlag.NOADDR);
        FLAG_MAPPING = Collections.unmodifiableMap(map);
    }
}

