/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.RedisURI;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.EpollProvider;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.KqueueProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class SocketAddressResolver {
    private final DnsResolver dnsResolver;

    protected SocketAddressResolver(DnsResolver dnsResolver) {
        LettuceAssert.notNull((Object)dnsResolver, "DnsResolver must not be null");
        this.dnsResolver = dnsResolver;
    }

    public static SocketAddressResolver create(DnsResolver dnsResolver) {
        return new SocketAddressResolver(dnsResolver);
    }

    public SocketAddress resolve(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        return SocketAddressResolver.resolve(redisURI, this.dnsResolver);
    }

    public static SocketAddress resolve(RedisURI redisURI, DnsResolver dnsResolver) {
        if (redisURI.getSocket() != null) {
            return SocketAddressResolver.getDomainSocketAddress(redisURI);
        }
        try {
            InetAddress[] inetAddress = dnsResolver.resolve(redisURI.getHost());
            if (inetAddress.length == 0) {
                return InetSocketAddress.createUnresolved(redisURI.getHost(), redisURI.getPort());
            }
            return new InetSocketAddress(inetAddress[0], redisURI.getPort());
        }
        catch (UnknownHostException e) {
            return new InetSocketAddress(redisURI.getHost(), redisURI.getPort());
        }
    }

    static SocketAddress getDomainSocketAddress(RedisURI redisURI) {
        if (KqueueProvider.isAvailable() || EpollProvider.isAvailable()) {
            EventLoopResources resources = KqueueProvider.isAvailable() ? KqueueProvider.getResources() : EpollProvider.getResources();
            return resources.newSocketAddress(redisURI.getSocket());
        }
        throw new IllegalStateException("No native transport available. Make sure that either netty's epoll or kqueue library is on the class path and supported by your operating system.");
    }
}

