/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.json.JsonArray;
import io.lettuce.core.json.JsonObject;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.JsonValue;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class UnproccessedJsonValue
implements JsonValue {
    private final Lock lock = new ReentrantLock();
    private volatile JsonValue jsonValue;
    private final JsonParser parser;
    private final ByteBuffer unprocessedData;

    public UnproccessedJsonValue(ByteBuffer bytes, JsonParser theParser) {
        this.unprocessedData = bytes;
        this.parser = theParser;
    }

    @Override
    public String toString() {
        if (this.unprocessedData == null) {
            return null;
        }
        if (this.isDeserialized()) {
            return this.jsonValue.toString();
        }
        this.lock.lock();
        try {
            if (this.isDeserialized()) {
                String string = this.jsonValue.toString();
                return string;
            }
            String string = StringCodec.UTF8.decodeValue(this.unprocessedData);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        if (this.isDeserialized()) {
            return this.jsonValue.asByteBuffer();
        }
        this.lock.lock();
        try {
            if (this.isDeserialized()) {
                ByteBuffer byteBuffer = this.jsonValue.asByteBuffer();
                return byteBuffer;
            }
            ByteBuffer byteBuffer = this.unprocessedData;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isJsonArray() {
        this.lazilyDeserialize();
        return this.jsonValue.isJsonArray();
    }

    @Override
    public JsonArray asJsonArray() {
        this.lazilyDeserialize();
        return this.jsonValue.asJsonArray();
    }

    @Override
    public boolean isJsonObject() {
        this.lazilyDeserialize();
        return this.jsonValue.isJsonObject();
    }

    @Override
    public JsonObject asJsonObject() {
        this.lazilyDeserialize();
        return this.jsonValue.asJsonObject();
    }

    @Override
    public boolean isString() {
        this.lazilyDeserialize();
        return this.jsonValue.isString();
    }

    @Override
    public String asString() {
        this.lazilyDeserialize();
        return this.jsonValue.asString();
    }

    @Override
    public boolean isNumber() {
        this.lazilyDeserialize();
        return this.jsonValue.isNumber();
    }

    @Override
    public Number asNumber() {
        this.lazilyDeserialize();
        return this.jsonValue.asNumber();
    }

    @Override
    public boolean isBoolean() {
        this.lazilyDeserialize();
        return this.jsonValue.isBoolean();
    }

    @Override
    public Boolean asBoolean() {
        this.lazilyDeserialize();
        return this.jsonValue.asBoolean();
    }

    @Override
    public boolean isNull() {
        this.lazilyDeserialize();
        return this.jsonValue.isNull();
    }

    @Override
    public <T> T toObject(Class<T> targetType) {
        this.lazilyDeserialize();
        return this.jsonValue.toObject(targetType);
    }

    private void lazilyDeserialize() {
        if (!this.isDeserialized()) {
            this.lock.lock();
            try {
                if (!this.isDeserialized()) {
                    this.jsonValue = this.parser.createJsonValue(this.unprocessedData);
                    if (this.unprocessedData != null) {
                        this.unprocessedData.clear();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    boolean isDeserialized() {
        return this.jsonValue != null;
    }
}

