/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.dubbo.gui;

import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AutoCompleter
implements KeyListener {
    private JComboBox owner = null;
    private JTextField editor = null;
    private ComboBoxModel model = null;

    public AutoCompleter(JComboBox comboBox) {
        this.owner = comboBox;
        this.editor = (JTextField)comboBox.getEditor().getEditorComponent();
        this.editor.addKeyListener(this);
        this.model = comboBox.getModel();
    }

    public AutoCompleter(JComboBox comboBox, ItemListener itemListener) {
        this.owner = comboBox;
        this.editor = (JTextField)comboBox.getEditor().getEditorComponent();
        this.editor.addKeyListener(this);
        this.model = comboBox.getModel();
        this.owner.addItemListener(itemListener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\n') {
            int caretPosition = this.editor.getCaretPosition();
            String str = this.editor.getText();
            if (str.length() == 0) {
                return;
            }
            this.autoComplete(str, caretPosition);
        }
    }

    protected void autoComplete(String strf, int caretPosition) {
        Object[] opts = this.getMatchingOptions(strf.substring(0, caretPosition));
        if (this.owner != null) {
            this.model = new DefaultComboBoxModel<Object>(opts);
            this.owner.setModel(this.model);
        }
        if (opts.length > 0) {
            String str = opts[0].toString();
            if (this.owner != null) {
                try {
                    this.owner.showPopup();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected Object[] getMatchingOptions(String str) {
        Vector v = new Vector();
        Vector v1 = new Vector();
        this.model = this.owner.getModel();
        for (int k = 0; k < this.model.getSize(); ++k) {
            Object itemObj = this.model.getElementAt(k);
            if (itemObj != null) {
                String item = itemObj.toString();
                if (item.toUpperCase().indexOf(str.toUpperCase()) != -1) {
                    v.add(this.model.getElementAt(k));
                    continue;
                }
                v1.add(this.model.getElementAt(k));
                continue;
            }
            v1.add(this.model.getElementAt(k));
        }
        for (int i = 0; i < v1.size(); ++i) {
            v.add(v1.get(i));
        }
        if (v.isEmpty()) {
            v.add(str);
        }
        return v.toArray();
    }
}

