/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.plugin.core;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.metersphere.plugin.core.MsParameter;
import io.metersphere.plugin.core.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.jmeter.save.SaveService;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="clazzName")
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class MsTestElement {
    private String type;
    private String clazzName = "io.metersphere.plugin.core.MsTestElement";
    @JSONField(ordinal=1)
    private String id;
    @JSONField(ordinal=2)
    private String name;
    @JSONField(ordinal=3)
    private String label;
    @JSONField(ordinal=4)
    private String resourceId;
    @JSONField(ordinal=5)
    private String referenced;
    @JSONField(ordinal=6)
    private boolean active;
    @JSONField(ordinal=7)
    private String index;
    @JSONField(ordinal=8)
    private boolean enable = true;
    @JSONField(ordinal=9)
    private String refType;
    @JSONField(ordinal=10)
    private LinkedList<MsTestElement> hashTree;
    @JSONField(ordinal=12)
    private String projectId;
    @JSONField(ordinal=13)
    private boolean isMockEnvironment;
    @JSONField(ordinal=14)
    private String environmentId;
    @JSONField(ordinal=15)
    private String pluginId;
    @JSONField(ordinal=16)
    private String stepName;
    private MsTestElement parent;

    public void toHashTree(HashTree tree, List<MsTestElement> hashTree, MsParameter config) {
        if (CollectionUtils.isNotEmpty(hashTree)) {
            for (MsTestElement el : hashTree) {
                el.toHashTree(tree, el.hashTree, config);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJmx(HashTree hashTree) {
        try (ByteArrayOutputStream bas = new ByteArrayOutputStream();){
            SaveService.saveTree((HashTree)hashTree, (OutputStream)bas);
            String string = bas.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.warn("HashTree error, can't log jmx scenarioDefinition");
            return null;
        }
    }

    public HashTree generateHashTree(MsParameter config) {
        ListedHashTree jmeterTestPlanHashTree = new ListedHashTree();
        this.toHashTree((HashTree)jmeterTestPlanHashTree, this.hashTree, config);
        return jmeterTestPlanHashTree;
    }

    public String getType() {
        return this.type;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getReferenced() {
        return this.referenced;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getRefType() {
        return this.refType;
    }

    public LinkedList<MsTestElement> getHashTree() {
        return this.hashTree;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public boolean isMockEnvironment() {
        return this.isMockEnvironment;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public MsTestElement getParent() {
        return this.parent;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setReferenced(String referenced) {
        this.referenced = referenced;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public void setHashTree(LinkedList<MsTestElement> hashTree) {
        this.hashTree = hashTree;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setMockEnvironment(boolean isMockEnvironment) {
        this.isMockEnvironment = isMockEnvironment;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setParent(MsTestElement parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsTestElement)) {
            return false;
        }
        MsTestElement other = (MsTestElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isMockEnvironment() != other.isMockEnvironment()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$clazzName = this.getClazzName();
        String other$clazzName = other.getClazzName();
        if (this$clazzName == null ? other$clazzName != null : !this$clazzName.equals(other$clazzName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$referenced = this.getReferenced();
        String other$referenced = other.getReferenced();
        if (this$referenced == null ? other$referenced != null : !this$referenced.equals(other$referenced)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$refType = this.getRefType();
        String other$refType = other.getRefType();
        if (this$refType == null ? other$refType != null : !this$refType.equals(other$refType)) {
            return false;
        }
        LinkedList<MsTestElement> this$hashTree = this.getHashTree();
        LinkedList<MsTestElement> other$hashTree = other.getHashTree();
        if (this$hashTree == null ? other$hashTree != null : !((Object)this$hashTree).equals(other$hashTree)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$stepName = this.getStepName();
        String other$stepName = other.getStepName();
        if (this$stepName == null ? other$stepName != null : !this$stepName.equals(other$stepName)) {
            return false;
        }
        MsTestElement this$parent = this.getParent();
        MsTestElement other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsTestElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isMockEnvironment() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $clazzName = this.getClazzName();
        result = result * 59 + ($clazzName == null ? 43 : $clazzName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $referenced = this.getReferenced();
        result = result * 59 + ($referenced == null ? 43 : $referenced.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $refType = this.getRefType();
        result = result * 59 + ($refType == null ? 43 : $refType.hashCode());
        LinkedList<MsTestElement> $hashTree = this.getHashTree();
        result = result * 59 + ($hashTree == null ? 43 : ((Object)$hashTree).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $stepName = this.getStepName();
        result = result * 59 + ($stepName == null ? 43 : $stepName.hashCode());
        MsTestElement $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    public String toString() {
        return "MsTestElement(type=" + this.getType() + ", clazzName=" + this.getClazzName() + ", id=" + this.getId() + ", name=" + this.getName() + ", label=" + this.getLabel() + ", resourceId=" + this.getResourceId() + ", referenced=" + this.getReferenced() + ", active=" + this.isActive() + ", index=" + this.getIndex() + ", enable=" + this.isEnable() + ", refType=" + this.getRefType() + ", hashTree=" + this.getHashTree() + ", projectId=" + this.getProjectId() + ", isMockEnvironment=" + this.isMockEnvironment() + ", environmentId=" + this.getEnvironmentId() + ", pluginId=" + this.getPluginId() + ", stepName=" + this.getStepName() + ", parent=" + this.getParent() + ")";
    }
}

