/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter;

import com.alibaba.fastjson.JSON;
import io.metersphere.cache.JMeterEngineCache;
import io.metersphere.constants.BackendListenerConstants;
import io.metersphere.dto.RequestResult;
import io.metersphere.dto.ResultDTO;
import io.metersphere.jmeter.JMeterBase;
import io.metersphere.utils.LoggerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;

public class APIBackendListenerClient
extends AbstractBackendListenerClient
implements Serializable {
    public static final String RUNNING_DEBUG_SAMPLER_NAME = "RunningDebugSampler";
    public String runMode = BackendListenerConstants.RUN.name();
    private final List<SampleResult> queue = new ArrayList<SampleResult>();
    private String testId;
    private String reportType;
    private String reportId;
    private String testPlanReportId;
    private Map<String, Object> producerProps;

    public void setupTest(BackendListenerContext context) throws Exception {
        this.setParam(context);
        super.setupTest(context);
    }

    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        this.queue.addAll(sampleResults);
    }

    public void teardownTest(BackendListenerContext context) throws Exception {
        LoggerUtil.info("\u63a5\u6536\u5230\u62a5\u544a\uff1a\u3010" + this.reportId + "\u3011,\u8d44\u6e90\u3010" + this.testId + "\u3011\u7684\u6267\u884c\u7ed3\u679c " + this.queue.size());
        ResultDTO dto = new ResultDTO();
        dto.setTestId(this.testId);
        dto.setRunMode(this.runMode);
        dto.setReportId(this.reportId);
        dto.setReportType(this.reportType);
        dto.setTestPlanReportId(this.testPlanReportId);
        try {
            LinkedList<RequestResult> requestResults = new LinkedList<RequestResult>();
            final ArrayList environmentList = new ArrayList();
            this.queue.forEach(result -> {
                if (StringUtils.equals((CharSequence)result.getSampleLabel(), (CharSequence)RUNNING_DEBUG_SAMPLER_NAME)) {
                    String evnStr = result.getResponseDataAsString();
                    environmentList.add(evnStr);
                } else {
                    requestResults.add(JMeterBase.getRequestResult(result));
                }
            });
            dto.setRequestResults(requestResults);
            dto.setArbitraryData((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("ENV", environmentList);
                }
            });
            JMeterEngineCache.runningEngine.remove(this.reportId);
            LoggerUtil.info("\u6e05\u7406\u6267\u884c\u961f\u5217\uff0c\u5269\u4f59\u5bb9\u91cf\uff1a" + JMeterEngineCache.runningEngine.size());
            Class<?> clazz = Class.forName("io.metersphere.api.jmeter.APIBackendListenerHandler");
            Object instance = clazz.newInstance();
            clazz.getDeclaredMethod("handleTeardownTest", ResultDTO.class, Map.class).invoke(instance, dto, this.producerProps);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"handleTeardownTest \u8c03\u7528\u5931\u8d25", e.getMessage());
        }
        super.teardownTest(context);
    }

    private void setParam(BackendListenerContext context) {
        this.testId = context.getParameter(BackendListenerConstants.TEST_ID.name());
        this.runMode = context.getParameter(BackendListenerConstants.RUN_MODE.name());
        this.reportId = context.getParameter(BackendListenerConstants.REPORT_ID.name());
        this.reportType = context.getParameter(BackendListenerConstants.REPORT_TYPE.name());
        this.testPlanReportId = context.getParameter(BackendListenerConstants.MS_TEST_PLAN_REPORT_ID.name());
        if (StringUtils.isNotEmpty((CharSequence)context.getParameter(BackendListenerConstants.KAFKA_CONFIG.name()))) {
            this.producerProps = (Map)JSON.parseObject((String)context.getParameter(BackendListenerConstants.KAFKA_CONFIG.name()), Map.class);
        }
        if (StringUtils.isBlank((CharSequence)this.runMode)) {
            this.runMode = BackendListenerConstants.RUN.name();
        }
    }
}

