/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter;

import com.alibaba.fastjson.JSON;
import io.metersphere.constants.BackendListenerConstants;
import io.metersphere.constants.HttpMethodConstants;
import io.metersphere.dto.JmeterRunRequestDTO;
import io.metersphere.dto.RequestResult;
import io.metersphere.dto.ResponseAssertionResult;
import io.metersphere.dto.ResponseResult;
import io.metersphere.jmeter.APIBackendListenerClient;
import io.metersphere.jmeter.SynchronousResultCollector;
import io.metersphere.utils.JMeterVars;
import io.metersphere.utils.LoggerUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jorphan.collections.HashTree;

public class JMeterBase {
    private static final String THREAD_SPLIT = " ";

    public static HashTree getHashTree(Object scriptWrapper) throws Exception {
        Field field = scriptWrapper.getClass().getDeclaredField("testPlan");
        field.setAccessible(true);
        return (HashTree)field.get(scriptWrapper);
    }

    public static void addBackendListener(JmeterRunRequestDTO request, HashTree hashTree) {
        LoggerUtil.debug("\u5f00\u59cb\u4e3a\u62a5\u544a\u3010 " + request.getReportId() + "\u3011\uff0c\u8d44\u6e90\u3010" + request.getTestId() + "\u3011\u6dfb\u52a0BackendListener");
        BackendListener backendListener = new BackendListener();
        backendListener.setName(request.getReportId() + "_" + request.getTestId());
        Arguments arguments = new Arguments();
        arguments.addArgument(BackendListenerConstants.TEST_ID.name(), request.getTestId());
        arguments.addArgument(BackendListenerConstants.REPORT_ID.name(), request.getReportId());
        arguments.addArgument(BackendListenerConstants.RUN_MODE.name(), request.getRunMode());
        arguments.addArgument(BackendListenerConstants.REPORT_TYPE.name(), request.getReportType());
        arguments.addArgument(BackendListenerConstants.MS_TEST_PLAN_REPORT_ID.name(), request.getTestPlanReportId());
        if (request.getKafkaConfig() != null && request.getKafkaConfig().size() > 0) {
            arguments.addArgument(BackendListenerConstants.KAFKA_CONFIG.name(), JSON.toJSONString(request.getKafkaConfig()));
        }
        backendListener.setArguments(arguments);
        backendListener.setClassname(APIBackendListenerClient.class.getCanonicalName());
        if (hashTree != null) {
            hashTree.add(hashTree.getArray()[0], (Object)backendListener);
        }
        LoggerUtil.debug("\u5f00\u59cb\u4e3a\u62a5\u544a\u3010 " + request.getReportId() + "\u3011\uff0c\u8d44\u6e90\u3010" + request.getTestId() + "\u3011\u6dfb\u52a0BackendListener \u7ed3\u675f");
    }

    public static void addSyncListener(JmeterRunRequestDTO request, HashTree hashTree, String listenerClazz) {
        LoggerUtil.debug("\u5f00\u59cb\u4e3a\u62a5\u544a\u3010 " + request.getReportId() + "\u3011\uff0c\u8d44\u6e90\u3010" + request.getTestId() + "\u3011\u6dfb\u52a0\u540c\u6b65\u7ed3\u679c\u76d1\u542c");
        SynchronousResultCollector backendListener = new SynchronousResultCollector();
        backendListener.setName(request.getReportId() + "_" + request.getTestId());
        backendListener.setReportId(request.getReportId());
        backendListener.setTestId(request.getTestId());
        backendListener.setRunMode(request.getRunMode());
        backendListener.setReportType(request.getReportType());
        backendListener.setTestPlanReportId(request.getTestPlanReportId());
        backendListener.setListenerClazz(listenerClazz);
        backendListener.setQueueId(request.getQueueId());
        backendListener.setRunType(request.getRunType());
        backendListener.setExtendedParameters(request.getExtendedParameters());
        if (request.getKafkaConfig() != null && request.getKafkaConfig().size() > 0) {
            backendListener.setProducerProps(request.getKafkaConfig());
        }
        if (hashTree != null) {
            hashTree.add(hashTree.getArray()[0], (Object)backendListener);
        }
        LoggerUtil.debug("\u5f00\u59cb\u4e3a\u62a5\u544a\u3010 " + request.getReportId() + "\u3011\uff0c\u8d44\u6e90\u3010" + request.getTestId() + "\u3011\u6dfb\u52a0\u540c\u6b65\u7ed3\u679c\u76d1\u542c\u7ed3\u675f");
    }

    public static RequestResult getRequestResult(SampleResult result) {
        LoggerUtil.debug("\u5f00\u59cb\u5904\u7406\u7ed3\u679c\u8d44\u6e90\u3010" + result.getSampleLabel() + "\u3011");
        String threadName = StringUtils.substringBeforeLast((String)result.getThreadName(), (String)THREAD_SPLIT);
        RequestResult requestResult = new RequestResult();
        requestResult.setThreadName(threadName);
        requestResult.setId(result.getSamplerId());
        requestResult.setResourceId(result.getResourceId());
        requestResult.setName(result.getSampleLabel());
        requestResult.setUrl(result.getUrlAsString());
        requestResult.setMethod(JMeterBase.getMethod(result));
        requestResult.setBody(result.getSamplerData());
        requestResult.setHeaders(result.getRequestHeaders());
        requestResult.setRequestSize(result.getSentBytes());
        requestResult.setStartTime(result.getStartTime());
        requestResult.setEndTime(result.getEndTime());
        requestResult.setTotalAssertions(result.getAssertionResults().length);
        requestResult.setSuccess(result.isSuccessful());
        requestResult.setError(result.getErrorCount());
        requestResult.setScenario(result.getScenario());
        if (result instanceof HTTPSampleResult) {
            SampleResult[] res = (SampleResult[])result;
            requestResult.setCookies(res.getCookies());
        }
        for (SampleResult subResult : result.getSubResults()) {
            requestResult.getSubRequestResults().add(JMeterBase.getRequestResult(subResult));
        }
        ResponseResult responseResult = requestResult.getResponseResult();
        responseResult.setBody(result.getResponseDataAsString());
        responseResult.setHeaders(result.getResponseHeaders());
        responseResult.setLatency(result.getLatency());
        responseResult.setResponseCode(result.getResponseCode());
        responseResult.setResponseSize(result.getResponseData().length);
        responseResult.setResponseTime(result.getTime());
        responseResult.setResponseMessage(result.getResponseMessage());
        JMeterVariables variables = JMeterVars.get(result.getResourceId());
        if (StringUtils.isNotEmpty((CharSequence)result.getExtVars())) {
            responseResult.setVars(result.getExtVars());
            JMeterVars.remove(result.getResourceId());
        } else if (variables != null && CollectionUtils.isNotEmpty((Collection)variables.entrySet())) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : variables.entrySet()) {
                builder.append((String)entry.getKey()).append("\uff1a").append(entry.getValue()).append("\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)builder)) {
                responseResult.setVars(builder.toString());
            }
            JMeterVars.remove(result.getResourceId());
        }
        for (AssertionResult assertionResult : result.getAssertionResults()) {
            ResponseAssertionResult responseAssertionResult = JMeterBase.getResponseAssertionResult(assertionResult);
            if (responseAssertionResult.isPass()) {
                requestResult.addPassAssertions();
            }
            if (!StringUtils.isBlank((CharSequence)responseAssertionResult.getMessage()) && (!StringUtils.isNotBlank((CharSequence)responseAssertionResult.getName()) || responseAssertionResult.getName().endsWith("XPath2Extractor")) && (!StringUtils.isNotBlank((CharSequence)responseAssertionResult.getContent()) || responseAssertionResult.getContent().endsWith("XPath2Extractor"))) continue;
            responseResult.getAssertions().add(responseAssertionResult);
        }
        LoggerUtil.debug("\u5904\u7406\u7ed3\u679c\u8d44\u6e90\u3010" + result.getSampleLabel() + "\u3011\u7ed3\u675f");
        return requestResult;
    }

    private static ResponseAssertionResult getResponseAssertionResult(AssertionResult assertionResult) {
        ResponseAssertionResult responseAssertionResult = new ResponseAssertionResult();
        responseAssertionResult.setName(assertionResult.getName());
        if (StringUtils.isNotEmpty((CharSequence)assertionResult.getName()) && assertionResult.getName().indexOf("split==") != -1) {
            if (assertionResult.getName().indexOf("JSR223") != -1) {
                String[] array = assertionResult.getName().split("split==", 3);
                if (array.length > 2 && "JSR223".equals(array[0])) {
                    responseAssertionResult.setName(array[1]);
                    if (array[2].indexOf("split&&") != -1) {
                        String[] content = array[2].split("split&&");
                        responseAssertionResult.setContent(content[0]);
                        if (content.length > 1) {
                            responseAssertionResult.setScript(content[1]);
                        }
                    } else {
                        responseAssertionResult.setContent(array[2]);
                    }
                }
            } else {
                String[] array = assertionResult.getName().split("split==");
                responseAssertionResult.setName(array[0]);
                StringBuffer content = new StringBuffer();
                for (int i = 1; i < array.length; ++i) {
                    content.append(array[i]);
                }
                responseAssertionResult.setContent(content.toString());
            }
        }
        responseAssertionResult.setPass(!assertionResult.isFailure() && !assertionResult.isError());
        if (!responseAssertionResult.isPass()) {
            responseAssertionResult.setMessage(assertionResult.getFailureMessage());
        }
        return responseAssertionResult;
    }

    private static String getMethod(SampleResult result) {
        String body = result.getSamplerData();
        String start = "RPC Protocol: ";
        String end = "://";
        if (StringUtils.contains((CharSequence)body, (CharSequence)start)) {
            String protocol = StringUtils.substringBetween((String)body, (String)start, (String)end);
            if (StringUtils.isNotEmpty((CharSequence)protocol)) {
                return protocol.toUpperCase();
            }
            return "DUBBO";
        }
        if (StringUtils.contains((CharSequence)result.getResponseHeaders(), (CharSequence)"url:jdbc")) {
            return "SQL";
        }
        String method = StringUtils.substringBefore((String)body, (String)THREAD_SPLIT);
        for (HttpMethodConstants value : HttpMethodConstants.values()) {
            if (!StringUtils.equals((CharSequence)method, (CharSequence)value.name())) continue;
            return method;
        }
        return "Request";
    }
}

