/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter;

import io.metersphere.cache.JMeterEngineCache;
import io.metersphere.utils.LoggerUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jorphan.collections.HashTree;

public class LocalRunner {
    private HashTree jmxTree;

    public LocalRunner(HashTree jmxTree) {
        this.jmxTree = jmxTree;
    }

    public LocalRunner() {
    }

    public void run(String report) {
        StandardJMeterEngine engine = new StandardJMeterEngine();
        engine.configure(this.jmxTree);
        try {
            LoggerUtil.info("LocalRunner \u5f00\u59cb\u6267\u884c\u62a5\u544a\u3010" + report + "\u3011");
            engine.runTest();
            JMeterEngineCache.runningEngine.put(report, engine);
        }
        catch (JMeterEngineException e) {
            engine.stopTest(true);
        }
    }

    public void stop(List<String> reports) {
        if (CollectionUtils.isNotEmpty(reports)) {
            for (String report : reports) {
                StandardJMeterEngine engine = JMeterEngineCache.runningEngine.get(report);
                if (engine == null) continue;
                engine.stopTest();
                JMeterEngineCache.runningEngine.remove(report);
            }
        }
    }

    public void stop(String report) {
        StandardJMeterEngine engine;
        if (StringUtils.isNotEmpty((CharSequence)report) && (engine = JMeterEngineCache.runningEngine.get(report)) != null) {
            engine.stopTest();
            JMeterEngineCache.runningEngine.remove(report);
        }
    }
}

