/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter;

import com.alibaba.fastjson.JSON;
import io.metersphere.constants.BackendListenerConstants;
import io.metersphere.dto.RequestResult;
import io.metersphere.dto.ResultDTO;
import io.metersphere.jmeter.JMeterBase;
import io.metersphere.jmeter.MsExecListener;
import io.metersphere.utils.JMeterVars;
import io.metersphere.utils.LoggerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;

public class SynchronousResultCollector
extends AbstractListenerElement
implements SampleListener,
Clearable,
Serializable,
TestStateListener,
Remoteable,
NoThreadClone {
    private static final String ERROR_LOGGING = "MsResultCollector.error_logging";
    private static final String TEST_IS_LOCAL = "*local*";
    private static final String SUCCESS_ONLY_LOGGING = "MsResultCollector.success_only_logging";
    public static final String RUNNING_DEBUG_SAMPLER_NAME = "RunningDebugSampler";
    private static final String PRE_PROCESS_SCRIPT = "PRE_PROCESSOR_ENV_";
    private static final String POST_PROCESS_SCRIPT = "POST_PROCESSOR_ENV_";
    private String runMode = BackendListenerConstants.RUN.name();
    private String listenerClazz;
    private String testId;
    private String reportType;
    private String reportId;
    private String queueId;
    private String runType;
    private String testPlanReportId;
    private Map<String, Object> producerProps;
    private Map<String, Object> extendedParameters;

    public Object clone() {
        SynchronousResultCollector clone = (SynchronousResultCollector)super.clone();
        return clone;
    }

    public static boolean isSampleWanted(boolean success, boolean errorOnly, boolean successOnly) {
        return !errorOnly && !successOnly || success && successOnly || !success && errorOnly;
    }

    public void testEnded(String host) {
        try {
            LoggerUtil.info("JMETER-\u6d4b\u8bd5\u62a5\u544a\u3010" + this.reportId + "\u3011\u8d44\u6e90\u3010 " + this.testId + " \u3011\u6267\u884c\u7ed3\u675f");
            ResultDTO dto = new ResultDTO();
            dto.setTestId(this.testId);
            dto.setRunMode(this.runMode);
            dto.setReportId(this.reportId);
            dto.setReportType(this.reportType);
            dto.setQueueId(this.queueId);
            dto.setRunType(this.runType);
            dto.setExtendedParameters(this.extendedParameters);
            dto.setTestPlanReportId(this.testPlanReportId);
            if (StringUtils.isEmpty((CharSequence)this.listenerClazz)) {
                this.listenerClazz = MsExecListener.class.getCanonicalName();
            }
            Class<?> clazz = Class.forName(this.listenerClazz);
            Object instance = clazz.newInstance();
            clazz.getDeclaredMethod("testEnded", ResultDTO.class, Map.class).invoke(instance, dto, this.producerProps);
        }
        catch (Exception e) {
            LoggerUtil.error("JMETER-\u6d4b\u8bd5\u62a5\u544a\u3010 " + this.reportId + "\u3011\u8d44\u6e90\u3010 " + this.testId + " \u3011\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void testStarted(String host) {
        LoggerUtil.info("TestStarted\u63a5\u6536\u5230\u53c2\u6570\uff1a\u62a5\u544a\u3010 " + this.reportId + " \u3011TestStarted\u63a5\u6536\u5230\u53c2\u6570\uff1a\u8d44\u6e90\u3010 " + this.testId + " \u3011TestStarted\u63a5\u6536\u5230\u53c2\u6570\uff1a\u6d4b\u8bd5\u8ba1\u5212\u62a5\u544a\u3010 " + this.testPlanReportId + " \u3011TestStarted\u63a5\u6536\u5230\u53c2\u6570\uff1a\u6267\u884c\u5bf9\u8c61\u3010 " + this.runMode + " \u3011TestStarted\u63a5\u6536\u5230\u53c2\u6570\uff1a\u62a5\u544a\u7c7b\u578b\u3010 " + this.reportType + " \u3011");
    }

    public void testEnded() {
        this.testEnded(TEST_IS_LOCAL);
    }

    public void testStarted() {
        this.testStarted(TEST_IS_LOCAL);
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public boolean isErrorLogging() {
        return this.getPropertyAsBoolean(ERROR_LOGGING);
    }

    public boolean isSuccessOnlyLogging() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY_LOGGING, false);
    }

    public boolean isSampleWanted(boolean success) {
        boolean errorOnly = this.isErrorLogging();
        boolean successOnly = this.isSuccessOnlyLogging();
        return SynchronousResultCollector.isSampleWanted(success, errorOnly, successOnly);
    }

    public void sampleOccurred(SampleEvent event) {
        SampleResult result = event.getResult();
        this.setVars(result);
        if (this.isSampleWanted(result.isSuccessful())) {
            LinkedList<RequestResult> requestResults = new LinkedList<RequestResult>();
            final ArrayList<String> environmentList = new ArrayList<String>();
            ResultDTO dto = new ResultDTO();
            dto.setTestId(this.testId);
            dto.setRunMode(this.runMode);
            dto.setReportId(this.reportId);
            dto.setReportType(this.reportType);
            dto.setTestPlanReportId(this.testPlanReportId);
            dto.setExtendedParameters(this.extendedParameters);
            dto.setQueueId(this.queueId);
            dto.setRunType(this.runType);
            RequestResult requestResult = JMeterBase.getRequestResult(result);
            if (StringUtils.equals((CharSequence)result.getSampleLabel(), (CharSequence)RUNNING_DEBUG_SAMPLER_NAME)) {
                String evnStr = result.getResponseDataAsString();
                environmentList.add(evnStr);
            } else {
                boolean resultNotFilterOut = this.checkResultIsNotFilterOut(requestResult);
                if (resultNotFilterOut) {
                    requestResults.add(requestResult);
                }
            }
            if (LoggerUtil.getLogger().isDebugEnabled()) {
                LoggerUtil.debug("JMETER-\u83b7\u53d6\u5230\u5355\u6761\u6267\u884c\u7ed3\u679c\u3010 " + JSON.toJSONString((Object)dto) + " \u3011");
            }
            if (StringUtils.isNotEmpty((CharSequence)requestResult.getName()) && requestResult.getName().startsWith("Transaction=")) {
                LoggerUtil.debug("JMETER-\u83b7\u53d6\u5230RunningDebugSampler \u5185\u5bb9 \u3010 " + requestResult + " \u3011");
                dto.setRequestResults(requestResult.getSubRequestResults());
            } else {
                dto.setRequestResults(requestResults);
            }
            try {
                dto.setArbitraryData((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("ENV", environmentList);
                    }
                });
                if (StringUtils.isEmpty((CharSequence)this.listenerClazz)) {
                    this.listenerClazz = MsExecListener.class.getCanonicalName();
                }
                Class<?> clazz = Class.forName(this.listenerClazz);
                Object instance = clazz.newInstance();
                clazz.getDeclaredMethod("handleTeardownTest", ResultDTO.class, Map.class).invoke(instance, dto, this.producerProps);
            }
            catch (Exception e) {
                LoggerUtil.error("JMETER-\u8c03\u7528\u5b58\u50a8\u65b9\u6cd5\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private boolean checkResultIsNotFilterOut(RequestResult result) {
        boolean resultNotFilterOut = true;
        if (StringUtils.startsWithAny((CharSequence)result.getName(), (CharSequence[])new CharSequence[]{PRE_PROCESS_SCRIPT})) {
            resultNotFilterOut = Boolean.parseBoolean(StringUtils.substring((String)result.getName(), (int)PRE_PROCESS_SCRIPT.length()));
        } else if (StringUtils.startsWithAny((CharSequence)result.getName(), (CharSequence[])new CharSequence[]{POST_PROCESS_SCRIPT})) {
            resultNotFilterOut = Boolean.parseBoolean(StringUtils.substring((String)result.getName(), (int)POST_PROCESS_SCRIPT.length()));
        }
        return resultNotFilterOut;
    }

    private void setVars(SampleResult result) {
        JMeterVariables variables;
        if (StringUtils.isNotEmpty((CharSequence)result.getSampleLabel()) && result.getSampleLabel().startsWith("Transaction=")) {
            for (int i = 0; i < result.getSubResults().length; ++i) {
                SampleResult subResult = result.getSubResults()[i];
                this.setVars(subResult);
            }
        }
        if ((variables = JMeterVars.get(result.getResourceId())) != null && CollectionUtils.isNotEmpty((Collection)variables.entrySet())) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : variables.entrySet()) {
                builder.append((String)entry.getKey()).append("\uff1a").append(entry.getValue()).append("\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)builder)) {
                result.setExtVars(builder.toString());
            }
        }
    }

    public void clearData() {
    }

    public void setRunType(String runType) {
        this.runType = runType;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public void setTestPlanReportId(String testPlanReportId) {
        this.testPlanReportId = testPlanReportId;
    }

    public void setProducerProps(Map<String, Object> producerProps) {
        this.producerProps = producerProps;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public void setListenerClazz(String listenerClazz) {
        this.listenerClazz = listenerClazz;
    }

    public void setExtendedParameters(Map<String, Object> extendedParameters) {
        this.extendedParameters = extendedParameters;
    }
}

