/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.utils;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import io.metersphere.vo.Condition;
import io.metersphere.vo.ElementCondition;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;

public class DocumentUtils {
    public static boolean documentChecked(Object subj, String condition, ThreadLocal<DecimalFormat> decimalFormatter) {
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            ElementCondition elementCondition = (ElementCondition)JSON.parseObject((String)condition, ElementCondition.class);
            boolean isTrue = true;
            if (CollectionUtils.isNotEmpty(elementCondition.getConditions())) {
                for (Condition item : elementCondition.getConditions()) {
                    String expectedValue = item.getValue() != null ? item.getValue().toString() : "";
                    String resValue = DocumentUtils.objectToString(subj, decimalFormatter);
                    switch (item.getKey()) {
                        case "value_eq": {
                            isTrue = DocumentUtils.valueEquals(resValue, expectedValue);
                            break;
                        }
                        case "value_not_eq": {
                            isTrue = DocumentUtils.valueNotEquals(resValue, expectedValue);
                            break;
                        }
                        case "value_in": {
                            isTrue = StringUtils.contains((CharSequence)resValue, (CharSequence)expectedValue);
                            break;
                        }
                        case "length_eq": {
                            isTrue = (long)DocumentUtils.getLength(subj, decimalFormatter) == DocumentUtils.numberOf(item.getValue());
                            break;
                        }
                        case "length_not_eq": {
                            isTrue = (long)DocumentUtils.getLength(subj, decimalFormatter) != DocumentUtils.numberOf(item.getValue());
                            break;
                        }
                        case "length_gt": {
                            isTrue = (long)DocumentUtils.getLength(subj, decimalFormatter) > DocumentUtils.numberOf(item.getValue());
                            break;
                        }
                        case "length_lt": {
                            isTrue = (long)DocumentUtils.getLength(subj, decimalFormatter) < DocumentUtils.numberOf(item.getValue());
                            break;
                        }
                        case "regular": {
                            Pattern pattern = JMeterUtils.getPatternCache().getPattern(expectedValue);
                            isTrue = JMeterUtils.getMatcher().matches(resValue, pattern);
                        }
                    }
                    if (isTrue) continue;
                    break;
                }
            }
            return isTrue && DocumentUtils.checkType(elementCondition, subj);
        }
        return true;
    }

    public static boolean checkType(ElementCondition elementCondition, Object subj) {
        if (elementCondition.isTypeVerification()) {
            return StringUtils.equalsIgnoreCase((CharSequence)elementCondition.getType(), (CharSequence)"object") || subj != null && StringUtils.equalsIgnoreCase((CharSequence)elementCondition.getType(), (CharSequence)DocumentUtils.getType(subj));
        }
        return true;
    }

    public static String getType(Object object) {
        String type = object.getClass().getName().substring(object.getClass().getName().lastIndexOf(".") + 1);
        if (StringUtils.equalsIgnoreCase((CharSequence)"Integer", (CharSequence)type)) {
            return type;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)type, (CharSequence[])new CharSequence[]{"integer", "float", "long", "double"})) {
            return "Number";
        }
        if (StringUtils.indexOfAny((CharSequence)type, (CharSequence[])new CharSequence[]{"Array", "List"}) != -1) {
            return "Array";
        }
        return type;
    }

    private static boolean valueEquals(String v1, String v2) {
        try {
            Number number1 = NumberUtils.createNumber((String)v1);
            Number number2 = NumberUtils.createNumber((String)v2);
            return number1.equals(number2);
        }
        catch (Exception e) {
            return StringUtils.equals((CharSequence)v1, (CharSequence)v2);
        }
    }

    private static boolean valueNotEquals(String v1, String v2) {
        try {
            Number number1 = NumberUtils.createNumber((String)v1);
            Number number2 = NumberUtils.createNumber((String)v2);
            return !number1.equals(number2);
        }
        catch (Exception e) {
            return !StringUtils.equals((CharSequence)v1, (CharSequence)v2);
        }
    }

    public static String objectToString(Object subj, ThreadLocal<DecimalFormat> decimalFormatter) {
        String str = subj == null ? "null" : (subj instanceof Map ? new Gson().toJson(subj) : (!(subj instanceof Double) && !(subj instanceof Float) ? subj.toString() : decimalFormatter.get().format(subj)));
        return str;
    }

    private static int getLength(Object value) {
        if (value != null) {
            if (value instanceof List) {
                return ((List)value).size();
            }
            return value.toString().length();
        }
        return 0;
    }

    private static int getLength(Object value, ThreadLocal<DecimalFormat> decimalFormatter) {
        if (value != null) {
            if (value instanceof Map) {
                return ((Map)value).size();
            }
            if (value instanceof List) {
                return ((List)value).size();
            }
            if (!(value instanceof Double) && !(value instanceof Float)) {
                return value.toString().length();
            }
            return decimalFormatter.get().format(value).length();
        }
        return 0;
    }

    private static long numberOf(Object value) {
        if (value != null) {
            try {
                return Long.parseLong(value.toString());
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static String documentMsg(String name, Object resValue, String condition) {
        String msg = "";
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            ElementCondition elementCondition = (ElementCondition)JSON.parseObject((String)condition, ElementCondition.class);
            if (CollectionUtils.isNotEmpty(elementCondition.getConditions())) {
                for (Condition item : elementCondition.getConditions()) {
                    if (StringUtils.equalsAny((CharSequence)item.getKey(), (CharSequence[])new CharSequence[]{"value_eq", "value_not_eq", "value_in"})) {
                        msg = resValue != null ? resValue.toString() : "";
                        continue;
                    }
                    if (StringUtils.equalsAny((CharSequence)item.getKey(), (CharSequence[])new CharSequence[]{"length_eq", "length_not_eq", "length_gt", "length_lt"})) {
                        msg = "\u957f\u5ea6\u662f\uff1a" + DocumentUtils.getLength(resValue) + "";
                        continue;
                    }
                    msg = resValue != null ? resValue.toString() : "";
                }
            }
            if (!DocumentUtils.checkType(elementCondition, resValue)) {
                msg = " \u7c7b\u578b\uff1a" + DocumentUtils.getType(resValue) + ", \u503c\uff1a" + msg;
            }
        }
        return (StringUtils.isNotEmpty((CharSequence)name) ? name.split("==")[1] : "") + "\u6821\u9a8c\u5931\u8d25\uff0c\u5b9e\u9645\u8fd4\u56de\uff1a" + msg;
    }
}

