/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.utils;

import com.alibaba.fastjson.JSON;
import io.github.ningyu.jmeter.plugin.dubbo.sample.DubboSample;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.extractor.JSR223PostProcessor;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.XPath2Extractor;
import org.apache.jmeter.extractor.json.jsonpath.JSONPostProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.collections.HashTree;

public class JMeterVars {
    private static Map<String, JMeterVariables> variables = new HashMap<String, JMeterVariables>();

    private JMeterVars() {
    }

    public static void addVars(String testId, JMeterVariables vars, String extract) {
        List<String> extracts;
        JMeterVariables vs = variables.get(testId);
        if (vs == null) {
            vs = new JMeterVariables();
        }
        if (!StringUtils.isEmpty((CharSequence)extract) && vars != null && CollectionUtils.isNotEmpty(extracts = Arrays.asList(extract.split(";")))) {
            for (String item : extracts) {
                String nrKey = item + "_matchNr";
                String nr = vars.get(nrKey);
                JMeterVariables jMeterVariables = new JMeterVariables();
                if (nr != null) {
                    int nrv = 0;
                    try {
                        nrv = Integer.valueOf(String.valueOf(nr));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nrv > 0) {
                        ArrayList<String> data = new ArrayList<String>();
                        for (int i = 1; i < nrv + 1; ++i) {
                            data.add(vars.get(item + "_" + i));
                        }
                        String array = JSON.toJSONString(data);
                        jMeterVariables.put(item, array);
                    }
                }
                if (jMeterVariables.get(item) != null) {
                    vs.put(item, jMeterVariables.get(item));
                    continue;
                }
                vs.put(item, vars.get(item) == null ? "" : vars.get(item));
            }
            vs.remove("TESTSTART.MS");
        }
        variables.put(testId, vs);
    }

    public static void addJSR223PostProcessor(HashTree tree) {
        for (Object key : tree.keySet()) {
            HashTree node = tree.get(key);
            if (key instanceof HTTPSamplerProxy || key instanceof DubboSample || key instanceof JDBCSampler) {
                StringJoiner extract = new StringJoiner(";");
                for (Object child : node.keySet()) {
                    RegexExtractor regexExtractor;
                    if (child instanceof RegexExtractor) {
                        regexExtractor = (RegexExtractor)child;
                        extract.add(regexExtractor.getRefName());
                        continue;
                    }
                    if (child instanceof XPath2Extractor) {
                        regexExtractor = (XPath2Extractor)child;
                        extract.add(regexExtractor.getRefName());
                        continue;
                    }
                    if (!(child instanceof JSONPostProcessor)) continue;
                    regexExtractor = (JSONPostProcessor)child;
                    extract.add(regexExtractor.getRefNames());
                }
                if (Optional.ofNullable(extract).orElse(extract).length() > 0) {
                    JSR223PostProcessor shell = new JSR223PostProcessor();
                    shell.setEnabled(true);
                    shell.setProperty("script", "io.metersphere.utils.JMeterVars.addVars(prev.hashCode(),vars,\"" + extract.toString() + "\");");
                    node.add(shell);
                }
            }
            if (node == null) continue;
            JMeterVars.addJSR223PostProcessor(node);
        }
    }

    public static JMeterVariables get(String key) {
        return variables.get(key);
    }

    public static void remove(String key) {
        variables.remove(key);
    }
}

