/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.metersphere.utils.DocumentUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(JSONPathAssertion.class);
    private static final long serialVersionUID = 2L;
    public static final String JSONPATH = "JSON_PATH";
    public static final String EXPECTED_VALUE = "EXPECTED_VALUE";
    public static final String JSON_VALIDATION = "JSONVALIDATION";
    public static final String EXPECT_NULL = "EXPECT_NULL";
    public static final String INVERT = "INVERT";
    public static final String IS_REGEX = "ISREGEX";
    private static ThreadLocal<DecimalFormat> decimalFormatter = ThreadLocal.withInitial(JSONPathAssertion::createDecimalFormat);

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormatter = new DecimalFormat("#.#");
        decimalFormatter.setMaximumFractionDigits(340);
        decimalFormatter.setMinimumFractionDigits(1);
        return decimalFormatter;
    }

    public String getOption() {
        return this.getPropertyAsString("ASS_OPTION");
    }

    public String getElementCondition() {
        return this.getPropertyAsString("ElementCondition");
    }

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTED_VALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTED_VALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSON_VALIDATION, jsonValidation);
    }

    public void setExpectNull(boolean val) {
        this.setProperty(EXPECT_NULL, val);
    }

    public boolean isExpectNull() {
        return this.getPropertyAsBoolean(EXPECT_NULL);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSON_VALIDATION);
    }

    public void setInvert(boolean invert) {
        this.setProperty(INVERT, invert);
    }

    public boolean isInvert() {
        return this.getPropertyAsBoolean(INVERT);
    }

    public void setIsRegex(boolean flag) {
        this.setProperty(IS_REGEX, flag);
    }

    public boolean isUseRegex() {
        return this.getPropertyAsBoolean(IS_REGEX, true);
    }

    private void doAssert(String jsonString) {
        Object value = JsonPath.read((String)jsonString, (String)this.getJsonPath(), (Predicate[])new Predicate[0]);
        if (this.isJsonValidationBool()) {
            if (value instanceof JSONArray ? this.arrayMatched((JSONArray)value) : this.isExpectNull() && value == null || this.isEquals(value)) {
                return;
            }
            if (this.isExpectNull()) {
                throw new IllegalStateException(String.format("Value expected to be null, but found '%s'", value));
            }
            String msg = "";
            if (this.isUseRegex()) {
                msg = "Value expected to match regexp '%s', but it did not match: '%s'";
            } else if (StringUtils.isNotEmpty((CharSequence)this.getOption()) && !this.isEquals(value)) {
                switch (this.getOption()) {
                    case "CONTAINS": {
                        msg = "Value contains to be '%s', but found '%s'";
                        break;
                    }
                    case "NOT_CONTAINS": {
                        msg = "Value not contains to be '%s', but found '%s'";
                        break;
                    }
                    case "EQUALS": {
                        msg = "Value equals to be '%s', but found '%s'";
                        break;
                    }
                    case "NOT_EQUALS": {
                        msg = "Value not equals to be '%s', but found '%s'";
                        break;
                    }
                    case "GT": {
                        msg = "Value > '%s', but found '%s'";
                        break;
                    }
                    case "LT": {
                        msg = "Value < '%s', but found '%s'";
                        break;
                    }
                    case "DOCUMENT": {
                        msg = DocumentUtils.documentMsg(this.getName(), value, this.getElementCondition());
                    }
                }
            } else {
                msg = "Value expected to be '%s', but found '%s'";
            }
            throw new IllegalStateException(String.format(msg, this.getExpectedValue(), DocumentUtils.objectToString(value, decimalFormatter)));
        }
    }

    private boolean arrayMatched(JSONArray value) {
        if (value.isEmpty() && "[]".equals(this.getExpectedValue())) {
            return true;
        }
        for (Object subj : value.toArray()) {
            if ((subj != null || !this.isExpectNull()) && !this.isEquals(subj)) continue;
            return true;
        }
        return this.isEquals(value);
    }

    private boolean isGt(String v1, String v2) {
        try {
            return Long.parseLong(v1) > Long.parseLong(v2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isLt(String v1, String v2) {
        try {
            return Long.parseLong(v1) < Long.parseLong(v2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isEquals(Object subj) {
        String str = DocumentUtils.objectToString(subj, decimalFormatter);
        if (this.isUseRegex()) {
            Pattern pattern = JMeterUtils.getPatternCache().getPattern(this.getExpectedValue());
            return JMeterUtils.getMatcher().matches(str, pattern);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getOption())) {
            boolean refFlag = false;
            switch (this.getOption()) {
                case "CONTAINS": {
                    refFlag = str.contains(this.getExpectedValue());
                    break;
                }
                case "NOT_CONTAINS": {
                    refFlag = !str.contains(this.getExpectedValue());
                    break;
                }
                case "EQUALS": {
                    refFlag = JSONPathAssertion.valueEquals(str, this.getExpectedValue());
                    break;
                }
                case "NOT_EQUALS": {
                    refFlag = JSONPathAssertion.valueNotEquals(str, this.getExpectedValue());
                    break;
                }
                case "GT": {
                    refFlag = this.isGt(str, this.getExpectedValue());
                    break;
                }
                case "LT": {
                    refFlag = this.isLt(str, this.getExpectedValue());
                    break;
                }
                case "DOCUMENT": {
                    refFlag = DocumentUtils.documentChecked(subj, this.getElementCondition(), decimalFormatter);
                }
            }
            return refFlag;
        }
        return str.equals(this.getExpectedValue());
    }

    private static boolean valueEquals(String v1, String v2) {
        try {
            Number number1 = NumberUtils.createNumber((String)v1);
            Number number2 = NumberUtils.createNumber((String)v2);
            return number1.equals(number2);
        }
        catch (Exception e) {
            return StringUtils.equals((CharSequence)v1, (CharSequence)v2);
        }
    }

    private static boolean valueNotEquals(String v1, String v2) {
        try {
            Number number1 = NumberUtils.createNumber((String)v1);
            Number number2 = NumberUtils.createNumber((String)v2);
            return !number1.equals(number2);
        }
        catch (Exception e) {
            return !StringUtils.equals((CharSequence)v1, (CharSequence)v2);
        }
    }

    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result = new AssertionResult(this.getName());
        String responseData = samplerResult.getResponseDataAsString();
        if (responseData.isEmpty()) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        result.setFailureMessage("");
        if (!this.isInvert()) {
            try {
                this.doAssert(responseData);
            }
            catch (Exception var6) {
                log.debug("Assertion failed", (Throwable)var6);
                result.setFailure(true);
                result.setFailureMessage(var6.getMessage());
            }
        } else {
            try {
                this.doAssert(responseData);
                result.setFailure(true);
                if (this.isJsonValidationBool()) {
                    if (this.isExpectNull()) {
                        result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches null");
                    } else {
                        result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches " + this.getExpectedValue());
                    }
                } else {
                    result.setFailureMessage("Failed that JSONPath not exists: " + this.getJsonPath());
                }
            }
            catch (Exception var5) {
                log.debug("Assertion failed, as expected", (Throwable)var5);
            }
        }
        return result;
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        decimalFormatter.remove();
    }
}

