/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.metersphere.utils.DocumentUtils;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.DecimalFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.minidev.json.JSONArray;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.LogErrorHandler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(XMLAssertion.class);
    private static ThreadLocal<DecimalFormat> decimalFormatter = ThreadLocal.withInitial(XMLAssertion::createDecimalFormat);
    private static final long serialVersionUID = 242L;
    private static final ThreadLocal<XMLReader> XML_READER = new ThreadLocal<XMLReader>(){

        @Override
        protected XMLReader initialValue() {
            try {
                XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                return reader;
            }
            catch (ParserConfigurationException | SAXException e) {
                log.error("Error initializing XMLReader in XMLAssertion", (Throwable)e);
                return null;
            }
        }
    };

    public String getXmlPath() {
        return this.getPropertyAsString("XML_PATH");
    }

    public String getExpectedValue() {
        return this.getPropertyAsString("EXPECTED_VALUE");
    }

    public String getCondition() {
        return this.getPropertyAsString("ElementCondition");
    }

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormatter = new DecimalFormat("#.#");
        decimalFormatter.setMaximumFractionDigits(340);
        decimalFormatter.setMinimumFractionDigits(1);
        return decimalFormatter;
    }

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        String resultData = response.getResponseDataAsString();
        if (resultData.length() == 0) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        XMLReader builder = XML_READER.get();
        if (builder != null) {
            try {
                builder.setErrorHandler((ErrorHandler)new LogErrorHandler());
                builder.parse(new InputSource(new StringReader(resultData)));
                try {
                    JSONObject xmlJSONObj = XML.toJSONObject((String)resultData);
                    String jsonPrettyPrintString = xmlJSONObj.toString(4);
                    this.doAssert(jsonPrettyPrintString);
                }
                catch (Exception e) {
                    result.setError(true);
                    result.setFailure(true);
                    result.setFailureMessage(e.getMessage());
                }
            }
            catch (IOException | SAXException e) {
                result.setError(true);
                result.setFailure(true);
                result.setFailureMessage(e.getMessage());
            }
        } else {
            result.setError(true);
            result.setFailureMessage("Cannot initialize XMLReader in element:" + this.getName() + ", check jmeter.log file");
        }
        return result;
    }

    private void doAssert(String jsonString) {
        Object value = JsonPath.read((String)jsonString, (String)this.getXmlPath(), (Predicate[])new Predicate[0]);
        if (value instanceof JSONArray && this.arrayMatched((JSONArray)value)) {
            return;
        }
        if (!this.isEquals(value)) {
            String msg = DocumentUtils.documentMsg(this.getName(), value, this.getCondition());
            throw new IllegalStateException(String.format(msg, this.getExpectedValue(), DocumentUtils.objectToString(value, decimalFormatter)));
        }
    }

    private boolean isEquals(Object subj) {
        String str = DocumentUtils.objectToString(subj, decimalFormatter);
        return DocumentUtils.documentChecked(str, this.getCondition(), decimalFormatter);
    }

    private boolean arrayMatched(JSONArray value) {
        if (value.isEmpty() && "[]".equals(this.getExpectedValue())) {
            return true;
        }
        for (Object subj : value.toArray()) {
            if (subj != null && !this.isEquals(subj)) continue;
            return true;
        }
        return this.isEquals(value);
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        XML_READER.remove();
    }
}

