/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.samplers.Interruptible;

public final class HTTPSamplerProxy
extends HTTPSamplerBase
implements Interruptible {
    private static final long serialVersionUID = 1L;
    private transient HTTPAbstractImpl impl;

    public HTTPSamplerProxy() {
    }

    public HTTPSamplerProxy(String impl) {
        this.setImplementation(impl);
    }

    protected String toExternalForm(URL u) {
        int len = u.getProtocol().length() + 1;
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            len += 2 + u.getAuthority().length();
        }
        if (u.getPath() != null) {
            len += u.getPath().length();
        }
        if (u.getQuery() != null) {
            len += 1 + u.getQuery().length();
        }
        if (u.getRef() != null) {
            len += 1 + u.getRef().length();
        }
        StringBuffer result = new StringBuffer(len);
        result.append(u.getProtocol());
        result.append(":");
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            result.append("//");
            result.append(u.getAuthority());
        }
        if (StringUtils.isNotEmpty((CharSequence)u.getPath())) {
            char ch;
            int index = 0;
            for (int i = 0; i < u.getPath().length() && String.valueOf(ch = u.getPath().charAt(i)).equals("/"); ++i) {
                ++index;
            }
            result.append("/" + u.getPath().substring(index));
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    protected HTTPSampleResult sample(URL u, String method, boolean areFollowingRedirect, int depth) {
        if (this.impl == null) {
            try {
                this.impl = HTTPSamplerFactory.getImplementation((String)this.getImplementation(), (HTTPSamplerBase)this);
            }
            catch (Exception ex) {
                return this.errorResult(ex, new HTTPSampleResult());
            }
        }
        try {
            String url = this.toExternalForm(u);
            if (StringUtils.isNotEmpty((CharSequence)url) && url.startsWith("http:/http")) {
                url = url.substring(6);
            }
            u = new URL(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.impl.sample(u, method, areFollowingRedirect, depth);
    }

    public void threadFinished() {
        if (this.impl != null) {
            this.impl.threadFinished();
        }
    }

    public boolean interrupt() {
        if (this.impl != null) {
            return this.impl.interrupt();
        }
        return false;
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.impl != null) {
            this.impl.notifyFirstSampleAfterLoopRestart();
        }
    }
}

