/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.OnErrorTestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultAction
extends OnErrorTestElement
implements Serializable,
SampleListener {
    private static final long serialVersionUID = 242L;
    private static final Logger log = LoggerFactory.getLogger(ResultAction.class);

    public void sampleOccurred(SampleEvent e) {
        SampleResult s = e.getResult();
        if (log.isDebugEnabled()) {
            log.debug("ResultStatusHandler {} for {} OK? {}", new Object[]{this.getName(), s.getSampleLabel(), s.isSuccessful()});
        }
        if (!s.isSuccessful()) {
            if (this.isStopTestNow()) {
                s.setStopTestNow(true);
            } else if (this.isStopTest()) {
                s.setStopTest(true);
            } else if (this.isStopThread()) {
                s.setStopThread(true);
            } else if (this.isStartNextThreadLoop()) {
                s.setTestLogicalAction(JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_THREAD);
            } else if (this.isStartNextIterationOfCurrentLoop()) {
                s.setTestLogicalAction(JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_CURRENT_LOOP);
            } else if (this.isBreakCurrentLoop()) {
                s.setTestLogicalAction(JMeterContext.TestLogicalAction.BREAK_CURRENT_LOOP);
            }
        } else if (this.getErrorAction() == 1000) {
            s.setTestLogicalAction(JMeterContext.TestLogicalAction.BREAK_CURRENT_LOOP);
        }
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }
}

