/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleResult
implements Serializable,
Cloneable,
Searchable {
    private static final long serialVersionUID = 241L;
    static Logger log = LoggerFactory.getLogger(SampleResult.class);
    public static final String DEFAULT_HTTP_ENCODING = StandardCharsets.ISO_8859_1.name();
    private static final String OK_CODE = Integer.toString(200);
    private static final String OK_MSG = "OK";
    private static final String INVALID_CALL_SEQUENCE_MSG = "Invalid call sequence";
    protected static final String DEFAULT_ENCODING = JMeterUtils.getPropDefault((String)"sampleresult.default.encoding", (String)DEFAULT_HTTP_ENCODING);
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    public static final String TEXT = "text";
    public static final String BINARY = "bin";
    private static final boolean DISABLE_SUBRESULTS_RENAMING = JMeterUtils.getPropDefault((String)"subresults.disable_renaming", (boolean)false);
    private static final String[] BINARY_TYPES = new String[]{"image/", "audio/", "video/"};
    private static final String[] NON_BINARY_TYPES = new String[]{"audio/x-mpegurl", "audio/mpegurl", "video/f4m", "image/svg+xml"};
    private static final byte[] EMPTY_BA = new byte[0];
    private static final SampleResult[] EMPTY_SR = new SampleResult[0];
    private static final AssertionResult[] EMPTY_AR = new AssertionResult[0];
    private static final boolean START_TIMESTAMP = JMeterUtils.getPropDefault((String)"sampleresult.timestamp.start", (boolean)false);
    private static final boolean USE_NANO_TIME = JMeterUtils.getPropDefault((String)"sampleresult.useNanoTime", (boolean)true);
    private static final long NANOTHREAD_SLEEP = JMeterUtils.getPropDefault((String)"sampleresult.nanoThreadSleep", (int)5000);
    private static final String NULL_FILENAME = "NULL";
    private String samplerId;
    private String resourceId;
    private String extVars;
    private String scenario;
    private SampleSaveConfiguration saveConfig;
    private SampleResult parent;
    private byte[] responseData = EMPTY_BA;
    private String responseCode = "";
    private String label = "";
    private String resultFileName = "";
    private String samplerData;
    private String threadName = "";
    private String responseMessage = "";
    private String responseHeaders = "";
    private String requestHeaders = "";
    private long timeStamp = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private long idleTime = 0L;
    private long pauseTime = 0L;
    private List<AssertionResult> assertionResults;
    private List<SampleResult> subResults;
    private String dataType = "";
    private boolean success;
    private final Set<String> files = ConcurrentHashMap.newKeySet(2);
    private String dataEncoding;
    private String contentType = "";
    private long elapsedTime = 0L;
    private long latency = 0L;
    private long connectTime = 0L;
    private JMeterContext.TestLogicalAction testLogicalAction = JMeterContext.TestLogicalAction.CONTINUE;
    private boolean stopThread = false;
    private boolean stopTest = false;
    private boolean stopTestNow = false;
    private int sampleCount = 1;
    private long bytes = 0L;
    private int headersSize = 0;
    private long bodySize = 0L;
    private volatile int groupThreads = 0;
    private volatile int allThreads = 0;
    private final long nanoTimeOffset;
    final boolean useNanoTime;
    final long nanoThreadSleep;
    private long sentBytes;
    private URL location;
    private transient boolean ignore;
    private transient int subResultIndex;
    private volatile transient String responseDataAsString;

    public String getSamplerId() {
        return this.samplerId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setExtVars(String vars) {
        this.extVars = vars;
    }

    public String getExtVars() {
        return this.extVars;
    }

    public SampleResult() {
        this(USE_NANO_TIME, NANOTHREAD_SLEEP);
    }

    SampleResult(boolean nanoTime) {
        this(nanoTime, NANOTHREAD_SLEEP);
    }

    SampleResult(boolean nanoTime, long nanoThreadSleep) {
        this.useNanoTime = nanoTime;
        this.nanoThreadSleep = nanoThreadSleep;
        this.nanoTimeOffset = this.initOffset();
        Sampler sampler = JMeterContextService.getContext().getCurrentSampler();
        if (sampler != null) {
            this.samplerId = sampler.getPropertyAsString("MS-ID");
            this.resourceId = sampler.getPropertyAsString("MS-RESOURCE-ID");
            this.scenario = sampler.getPropertyAsString("MS-SCENARIO");
        }
    }

    public SampleResult(SampleResult res) {
        this();
        this.allThreads = res.allThreads;
        this.assertionResults = res.assertionResults;
        this.bytes = res.bytes;
        this.headersSize = res.headersSize;
        this.bodySize = res.bodySize;
        this.contentType = res.contentType;
        this.dataEncoding = res.dataEncoding;
        this.dataType = res.dataType;
        this.endTime = res.endTime;
        this.groupThreads = res.groupThreads;
        this.idleTime = res.idleTime;
        this.label = res.label;
        this.latency = res.latency;
        this.connectTime = res.connectTime;
        this.location = res.location;
        this.parent = res.parent;
        this.pauseTime = res.pauseTime;
        this.requestHeaders = res.requestHeaders;
        this.responseCode = res.responseCode;
        this.responseData = res.responseData;
        this.responseDataAsString = null;
        this.responseHeaders = res.responseHeaders;
        this.responseMessage = res.responseMessage;
        this.sampleCount = res.sampleCount;
        this.samplerData = res.samplerData;
        this.saveConfig = res.saveConfig;
        this.sentBytes = res.sentBytes;
        this.startTime = res.startTime;
        this.stopTest = res.stopTest;
        this.stopTestNow = res.stopTestNow;
        this.stopThread = res.stopThread;
        this.testLogicalAction = res.testLogicalAction;
        this.subResults = res.subResults;
        this.success = res.success;
        this.threadName = res.threadName;
        this.elapsedTime = res.elapsedTime;
        this.timeStamp = res.timeStamp;
    }

    protected SampleResult(long elapsed, boolean atend) {
        this();
        long now = this.currentTimeInMillis();
        if (atend) {
            this.setTimes(now - elapsed, now);
        } else {
            this.setTimes(now, now + elapsed);
        }
    }

    public SampleResult(long stamp, long elapsed) {
        this();
        this.stampAndTime(stamp, elapsed);
    }

    private long initOffset() {
        if (this.useNanoTime) {
            return this.nanoThreadSleep > 0L ? NanoOffset.getNanoOffset() : System.currentTimeMillis() - SampleResult.sampleNsClockInMs();
        }
        return Long.MIN_VALUE;
    }

    public void setSaveConfig(SampleSaveConfiguration propertiesToSave) {
        this.saveConfig = propertiesToSave;
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public boolean isStampedAtStart() {
        return START_TIMESTAMP;
    }

    public static SampleResult createTestSample(long start, long end) {
        SampleResult res = new SampleResult();
        res.setStartTime(start);
        res.setEndTime(end);
        return res;
    }

    public static SampleResult createTestSample(long elapsed) {
        long now = System.currentTimeMillis();
        return SampleResult.createTestSample(now, now + elapsed);
    }

    private static long sampleNsClockInMs() {
        return System.nanoTime() / 1000000L;
    }

    public long currentTimeInMillis() {
        if (this.useNanoTime) {
            if (this.nanoTimeOffset == Long.MIN_VALUE) {
                throw new IllegalStateException("Invalid call; nanoTimeOffset has not been set");
            }
            return SampleResult.sampleNsClockInMs() + this.nanoTimeOffset;
        }
        return System.currentTimeMillis();
    }

    private void stampAndTime(long stamp, long elapsed) {
        if (START_TIMESTAMP) {
            this.startTime = stamp;
            this.endTime = stamp + elapsed;
        } else {
            this.startTime = stamp - elapsed;
            this.endTime = stamp;
        }
        this.timeStamp = stamp;
        this.elapsedTime = elapsed;
    }

    public void setStampAndTime(long stamp, long elapsed) {
        if (this.startTime != 0L || this.endTime != 0L) {
            throw new IllegalStateException("Calling setStampAndTime() after start/end times have been set");
        }
        this.stampAndTime(stamp, elapsed);
    }

    public boolean markFile(String filename) {
        return !this.files.add(filename != null ? filename : NULL_FILENAME);
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCodeOK() {
        this.responseCode = OK_CODE;
    }

    public void setResponseCode(String code) {
        this.responseCode = code;
    }

    public boolean isResponseCodeOK() {
        return this.responseCode.equals(OK_CODE);
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String msg) {
        this.responseMessage = msg;
    }

    public void setResponseMessageOK() {
        this.responseMessage = OK_MSG;
    }

    public void setResponseOK() {
        this.setResponseCodeOK();
        this.setResponseMessageOK();
        this.setSuccessful(true);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSampleLabel() {
        return this.label;
    }

    public String getSampleLabel(boolean includeGroup) {
        if (includeGroup) {
            return this.threadName.substring(0, this.threadName.lastIndexOf(32)) + ":" + this.label;
        }
        return this.label;
    }

    public void setSampleLabel(String label) {
        this.label = label;
    }

    public void addAssertionResult(AssertionResult assertResult) {
        if (this.assertionResults == null) {
            this.assertionResults = new ArrayList<AssertionResult>();
        }
        this.assertionResults.add(assertResult);
    }

    public AssertionResult[] getAssertionResults() {
        if (this.assertionResults == null) {
            return EMPTY_AR;
        }
        return this.assertionResults.toArray(new AssertionResult[this.assertionResults.size()]);
    }

    public void addSubResult(SampleResult subResult) {
        this.addSubResult(subResult, SampleResult.isRenameSampleLabel());
    }

    public static boolean isRenameSampleLabel() {
        return !TestPlan.getFunctionalMode() && !DISABLE_SUBRESULTS_RENAMING;
    }

    public void addSubResult(SampleResult subResult, boolean renameSubResults) {
        if (subResult == null) {
            return;
        }
        String tn = this.getThreadName();
        if (tn.length() == 0) {
            tn = Thread.currentThread().getName();
            this.setThreadName(tn);
        }
        subResult.setThreadName(tn);
        this.setEndTime(Math.max(this.getEndTime(), subResult.getEndTime() + this.nanoTimeOffset - subResult.nanoTimeOffset));
        this.setBytes(this.getBytesAsLong() + subResult.getBytesAsLong());
        this.setSentBytes(this.getSentBytes() + subResult.getSentBytes());
        this.setHeadersSize(this.getHeadersSize() + subResult.getHeadersSize());
        this.setBodySize(this.getBodySizeAsLong() + subResult.getBodySizeAsLong());
        this.addRawSubResult(subResult, renameSubResults);
    }

    public void addRawSubResult(SampleResult subResult) {
        this.storeSubResult(subResult, SampleResult.isRenameSampleLabel());
    }

    private void addRawSubResult(SampleResult subResult, boolean renameSubResults) {
        this.storeSubResult(subResult, renameSubResults);
    }

    public void storeSubResult(SampleResult subResult) {
        this.storeSubResult(subResult, SampleResult.isRenameSampleLabel());
    }

    private void storeSubResult(SampleResult subResult, boolean renameSubResults) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<SampleResult>();
        }
        if (renameSubResults) {
            subResult.setSampleLabel(this.getSampleLabel() + "-" + this.subResultIndex++);
        }
        this.subResults.add(subResult);
        subResult.setParent(this);
    }

    public SampleResult[] getSubResults() {
        if (this.subResults == null) {
            return EMPTY_SR;
        }
        return this.subResults.toArray(new SampleResult[this.subResults.size()]);
    }

    public void setResponseData(byte[] response) {
        this.responseDataAsString = null;
        this.responseData = response == null ? EMPTY_BA : response;
    }

    @Deprecated
    public void setResponseData(String response) {
        this.responseDataAsString = null;
        try {
            this.responseData = response.getBytes(this.getDataEncodingWithDefault());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not convert string, using default encoding. " + e.getLocalizedMessage());
            this.responseData = response.getBytes(Charset.defaultCharset());
        }
    }

    public void setResponseData(String response, String encoding) {
        this.responseDataAsString = null;
        String encodeUsing = encoding != null ? encoding : DEFAULT_CHARSET;
        try {
            this.responseData = response.getBytes(encodeUsing);
            this.setDataEncoding(encodeUsing);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not convert string using '" + encodeUsing + "', using default encoding: " + DEFAULT_CHARSET, (Throwable)e);
            this.responseData = response.getBytes(Charset.defaultCharset());
            this.setDataEncoding(DEFAULT_CHARSET);
        }
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public String getResponseDataAsString() {
        try {
            if (this.responseDataAsString == null) {
                this.responseDataAsString = new String(this.responseData, this.getDataEncodingWithDefault());
            }
            return this.responseDataAsString;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Using platform default as " + this.getDataEncodingWithDefault() + " caused " + e);
            return new String(this.responseData, Charset.defaultCharset());
        }
    }

    public void setSamplerData(String s) {
        this.samplerData = s;
    }

    public String getSamplerData() {
        return this.samplerData;
    }

    public long getTime() {
        return this.elapsedTime;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setEncodingAndType(String ct) {
        if (ct != null) {
            String charsetPrefix = "charset=";
            int cset = ct.toLowerCase(Locale.ENGLISH).indexOf("charset=");
            if (cset >= 0) {
                String charSet = ct.substring(cset + "charset=".length());
                int semiColon = charSet.indexOf(59);
                if (semiColon >= 0) {
                    charSet = charSet.substring(0, semiColon);
                }
                if (charSet.startsWith("\"") || charSet.startsWith("'")) {
                    this.setDataEncoding(charSet.substring(1, charSet.length() - 1));
                } else {
                    this.setDataEncoding(charSet);
                }
            }
            if (SampleResult.isBinaryType(ct)) {
                this.setDataType(BINARY);
            } else {
                this.setDataType(TEXT);
            }
        }
    }

    public static boolean isBinaryType(String ct) {
        for (String entry : NON_BINARY_TYPES) {
            if (!ct.startsWith(entry)) continue;
            return false;
        }
        for (String binaryType : BINARY_TYPES) {
            if (!ct.startsWith(binaryType)) continue;
            return true;
        }
        return false;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }

    public String toString() {
        return this.getSampleLabel();
    }

    public String getDataEncodingWithDefault() {
        return this.getDataEncodingWithDefault(DEFAULT_ENCODING);
    }

    protected String getDataEncodingWithDefault(String defaultEncoding) {
        if (this.dataEncoding != null && this.dataEncoding.length() > 0) {
            return this.dataEncoding;
        }
        return defaultEncoding;
    }

    public String getDataEncodingNoDefault() {
        return this.dataEncoding;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public boolean isStopTest() {
        return this.stopTest;
    }

    public boolean isStopTestNow() {
        return this.stopTestNow;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopTest(boolean b) {
        this.stopTest = b;
    }

    public void setStopTestNow(boolean b) {
        this.stopTestNow = b;
    }

    public void setStopThread(boolean b) {
        this.stopThread = b;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setRequestHeaders(String string) {
        this.requestHeaders = string;
    }

    public void setResponseHeaders(String string) {
        this.responseHeaders = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMediaType() {
        return JOrphanUtils.trim((String)this.contentType, (String)" ;").toLowerCase(Locale.ENGLISH);
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(long start) {
        this.startTime = start;
        if (START_TIMESTAMP) {
            this.timeStamp = this.startTime;
        }
    }

    public void setEndTime(long end) {
        this.endTime = end;
        if (!START_TIMESTAMP) {
            this.timeStamp = this.endTime;
        }
        if (this.startTime == 0L) {
            log.error("setEndTime must be called after setStartTime", new Throwable(INVALID_CALL_SEQUENCE_MSG));
        } else {
            this.elapsedTime = this.endTime - this.startTime - this.idleTime;
        }
    }

    public void setIdleTime(long idle) {
        this.idleTime = idle;
    }

    private void setTimes(long start, long end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public void sampleStart() {
        if (this.startTime == 0L) {
            this.setStartTime(this.currentTimeInMillis());
        } else {
            log.error("sampleStart called twice", new Throwable(INVALID_CALL_SEQUENCE_MSG));
        }
    }

    public void sampleEnd() {
        if (this.endTime == 0L) {
            this.setEndTime(this.currentTimeInMillis());
        } else {
            log.error("sampleEnd called twice", new Throwable(INVALID_CALL_SEQUENCE_MSG));
        }
    }

    public void samplePause() {
        if (this.pauseTime != 0L) {
            log.error("samplePause called twice", new Throwable(INVALID_CALL_SEQUENCE_MSG));
        }
        this.pauseTime = this.currentTimeInMillis();
    }

    public void sampleResume() {
        if (this.pauseTime == 0L) {
            log.error("sampleResume without samplePause", new Throwable(INVALID_CALL_SEQUENCE_MSG));
        }
        this.idleTime += this.currentTimeInMillis() - this.pauseTime;
        this.pauseTime = 0L;
    }

    @Deprecated
    public void setMonitor(boolean monitor) {
    }

    @Deprecated
    public boolean isMonitor() {
        return false;
    }

    public void setSampleCount(int count) {
        this.sampleCount = count;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getErrorCount() {
        return this.success ? 0 : 1;
    }

    public void setErrorCount(int i) {
    }

    public void setBytes(long length) {
        this.bytes = length;
    }

    @Deprecated
    public void setBytes(int length) {
        this.setBytes((long)length);
    }

    public void setSentBytes(long sentBytesCount) {
        this.sentBytes = sentBytesCount;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    @Deprecated
    public int getBytes() {
        return (int)this.getBytesAsLong();
    }

    public long getBytesAsLong() {
        long tmpSum = (long)this.getHeadersSize() + this.getBodySizeAsLong();
        return tmpSum == 0L ? this.bytes : tmpSum;
    }

    public long getLatency() {
        return this.latency;
    }

    public void latencyEnd() {
        this.latency = this.currentTimeInMillis() - this.startTime - this.idleTime;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void connectEnd() {
        this.connectTime = this.currentTimeInMillis() - this.startTime - this.idleTime;
    }

    public void setConnectTime(long time) {
        this.connectTime = time;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setURL(URL location) {
        this.location = location;
    }

    public URL getURL() {
        return this.location;
    }

    public String getUrlAsString() {
        return this.location == null ? "" : this.location.toExternalForm();
    }

    public SampleResult getParent() {
        return this.parent;
    }

    public void setParent(SampleResult parent) {
        this.parent = parent;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public int getGroupThreads() {
        return this.groupThreads;
    }

    public void setGroupThreads(int n) {
        this.groupThreads = n;
    }

    public int getAllThreads() {
        return this.allThreads;
    }

    public void setAllThreads(int n) {
        this.allThreads = n;
    }

    public void removeAssertionResults() {
        this.assertionResults = null;
    }

    public void removeSubResults() {
        this.subResults = null;
    }

    public void setHeadersSize(int size) {
        this.headersSize = size;
    }

    public int getHeadersSize() {
        return this.headersSize;
    }

    @Deprecated
    public int getBodySize() {
        return (int)this.getBodySizeAsLong();
    }

    public long getBodySizeAsLong() {
        return this.bodySize == 0L ? (long)this.responseData.length : this.bodySize;
    }

    public void setBodySize(long bodySize) {
        this.bodySize = bodySize;
    }

    @Deprecated
    public void setBodySize(int bodySize) {
        this.bodySize = bodySize;
    }

    @Deprecated
    public boolean isStartNextThreadLoop() {
        return this.testLogicalAction == JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_THREAD;
    }

    @Deprecated
    public void setStartNextThreadLoop(boolean startNextThreadLoop) {
        this.testLogicalAction = startNextThreadLoop ? JMeterContext.TestLogicalAction.START_NEXT_ITERATION_OF_THREAD : JMeterContext.TestLogicalAction.CONTINUE;
    }

    public void cleanAfterSample() {
        this.responseDataAsString = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("This should not happen");
        }
    }

    public List<String> getSearchableTokens() throws Exception {
        ArrayList<String> datasToSearch = new ArrayList<String>(4);
        datasToSearch.add(this.getSampleLabel());
        datasToSearch.add(this.getResponseDataAsString());
        datasToSearch.add(this.getRequestHeaders());
        datasToSearch.add(this.getResponseHeaders());
        return datasToSearch;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore() {
        this.ignore = true;
    }

    public String getFirstAssertionFailureMessage() {
        String message = null;
        AssertionResult[] results = this.getAssertionResults();
        if (results != null) {
            AssertionResult result;
            AssertionResult[] assertionResultArray = results;
            int n = assertionResultArray.length;
            for (int i = 0; i < n && (message = (result = assertionResultArray[i]).getFailureMessage()) == null; ++i) {
            }
        }
        return message;
    }

    public JMeterContext.TestLogicalAction getTestLogicalAction() {
        return this.testLogicalAction;
    }

    public void setTestLogicalAction(JMeterContext.TestLogicalAction testLogicalAction) {
        this.testLogicalAction = testLogicalAction;
    }

    static {
        if (START_TIMESTAMP) {
            log.info("Note: Sample TimeStamps are START times");
        } else {
            log.info("Note: Sample TimeStamps are END times");
        }
        log.info("sampleresult.default.encoding is set to {}", (Object)DEFAULT_ENCODING);
        log.info("sampleresult.useNanoTime={}", (Object)USE_NANO_TIME);
        log.info("sampleresult.nanoThreadSleep={}", (Object)NANOTHREAD_SLEEP);
        if (USE_NANO_TIME && NANOTHREAD_SLEEP > 0L) {
            NanoOffset.nanoOffset = System.currentTimeMillis() - SampleResult.sampleNsClockInMs();
            NanoOffset nanoOffset = new NanoOffset();
            nanoOffset.setDaemon(true);
            nanoOffset.setName("NanoOffset");
            nanoOffset.start();
        }
    }

    private static class NanoOffset
    extends Thread {
        private static volatile long nanoOffset;

        private NanoOffset() {
        }

        static long getNanoOffset() {
            return nanoOffset;
        }

        @Override
        public void run() {
            NanoOffset.getOffset(30L);
            while (true) {
                NanoOffset.getOffset(NANOTHREAD_SLEEP);
            }
        }

        private static void getOffset(long wait) {
            try {
                TimeUnit.MILLISECONDS.sleep(wait);
                long clock = System.currentTimeMillis();
                long nano = SampleResult.sampleNsClockInMs();
                nanoOffset = clock - nano;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

