/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.ScriptingBeanInfoSupport;
import org.apache.jmeter.util.ScriptingTestElement;
import org.apache.jorphan.util.JOrphanUtils;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSR223TestElement
extends ScriptingTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 232L;
    private static final Logger logger = LoggerFactory.getLogger(JSR223TestElement.class);
    private static final Map<String, CompiledScript> compiledScriptsCache = Collections.synchronizedMap(new LRUMap(JMeterUtils.getPropDefault((String)"jsr223.compiled_scripts_cache_size", (int)100)));
    private String cacheKey = "";
    private String scriptMd5 = null;

    public static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    protected ScriptEngine getScriptEngine() throws ScriptException {
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        if (scriptEngine == null) {
            throw new ScriptException("Cannot find engine named: '" + lang + "', ensure you set language field in JSR223 Test Element: " + this.getName());
        }
        return scriptEngine;
    }

    private String getScriptLanguageWithDefault() {
        String lang = this.getScriptLanguage();
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            return lang;
        }
        return "groovy";
    }

    protected void populateBindings(Bindings bindings) {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger elementLogger = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.getName()));
        bindings.put("log", (Object)elementLogger);
        bindings.put("Label", (Object)label);
        bindings.put("FileName", (Object)fileName);
        bindings.put("Parameters", (Object)scriptParameters);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        bindings.put("args", (Object)args);
        JMeterContext jmctx = JMeterContextService.getContext();
        bindings.put("ctx", (Object)jmctx);
        JMeterVariables vars = jmctx.getVariables();
        bindings.put("vars", (Object)vars);
        Properties props = JMeterUtils.getJMeterProperties();
        bindings.put("props", (Object)props);
        bindings.put("OUT", (Object)System.out);
        Sampler sampler = jmctx.getCurrentSampler();
        bindings.put("sampler", (Object)sampler);
        SampleResult prev = jmctx.getPreviousResult();
        bindings.put("prev", (Object)prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object processFileOrScript(ScriptEngine scriptEngine, Bindings pBindings) throws IOException, ScriptException {
        Bindings bindings;
        if (scriptEngine instanceof GroovyScriptEngineImpl) {
            try {
                GroovyScriptEngineImpl groovyScriptEngine = (GroovyScriptEngineImpl)scriptEngine;
                Class<?> clazz = Class.forName("io.metersphere.api.jmeter.GroovyLoadJarService");
                Object instance = clazz.newInstance();
                clazz.getDeclaredMethod("loadGroovyJar", GroovyClassLoader.class).invoke(instance, groovyScriptEngine.getClassLoader());
            }
            catch (Exception e) {
                logger.error("\u52a0\u8f7djar\u5931\u8d25\uff1a", (Object)e.getMessage());
            }
        }
        if ((bindings = pBindings) == null) {
            bindings = scriptEngine.createBindings();
        }
        this.populateBindings(bindings);
        File scriptFile = new File(this.getFilename());
        boolean supportsCompilable = scriptEngine instanceof Compilable && !"bsh.engine.BshScriptEngine".equals(scriptEngine.getClass().getName());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        NewDriver.setContextClassLoader();
        try {
            Object compiledScript2;
            if (!StringUtils.isEmpty((CharSequence)this.getFilename())) {
                if (!scriptFile.exists()) throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' does not exist or is unreadable for element:" + this.getName());
                if (!scriptFile.canRead()) throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' does not exist or is unreadable for element:" + this.getName());
                if (supportsCompilable) {
                    Object object;
                    String newCacheKey = this.getScriptLanguage() + "#" + scriptFile.getAbsolutePath() + "#" + scriptFile.lastModified();
                    CompiledScript compiledScript2 = compiledScriptsCache.get(newCacheKey);
                    if (compiledScript2 == null) {
                        object = compiledScriptsCache;
                        synchronized (object) {
                            compiledScript2 = compiledScriptsCache.get(newCacheKey);
                            if (compiledScript2 == null) {
                                try (BufferedReader fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());){
                                    compiledScript2 = ((Compilable)((Object)scriptEngine)).compile(fileReader);
                                    compiledScriptsCache.put(newCacheKey, compiledScript2);
                                }
                            }
                        }
                    }
                    object = compiledScript2.eval(bindings);
                    return object;
                }
                BufferedReader fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());
                compiledScript2 = null;
                try {
                    Object object = scriptEngine.eval((Reader)fileReader, bindings);
                    return object;
                }
                catch (Throwable throwable) {
                    compiledScript2 = throwable;
                    throw throwable;
                }
                finally {
                    if (fileReader != null) {
                        if (compiledScript2 != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)compiledScript2).addSuppressed(throwable);
                            }
                        } else {
                            fileReader.close();
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.getScript())) {
                if (supportsCompilable && !ScriptingBeanInfoSupport.FALSE_AS_STRING.equals(this.cacheKey)) {
                    this.computeScriptMD5();
                    CompiledScript compiledScript3 = compiledScriptsCache.get(this.scriptMd5);
                    if (compiledScript3 == null) {
                        compiledScript2 = compiledScriptsCache;
                        synchronized (compiledScript2) {
                            compiledScript3 = compiledScriptsCache.get(this.scriptMd5);
                            if (compiledScript3 == null) {
                                try {
                                    compiledScript3 = ((Compilable)((Object)scriptEngine)).compile(this.getScript());
                                    compiledScriptsCache.put(this.scriptMd5, compiledScript3);
                                }
                                catch (IllegalArgumentException e) {
                                    Object object = new Object();
                                    // MONITOREXIT @DISABLED, blocks:[48, 49, 1, 20, 37, 31, 47] lbl89 : MonitorExitStatement: MONITOREXIT : compiledScript
                                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                                    return object;
                                }
                            }
                        }
                    }
                    compiledScript2 = compiledScript3.eval(bindings);
                    return compiledScript2;
                }
                Object compiledScript3 = scriptEngine.eval(this.getScript(), bindings);
                return compiledScript3;
            }
            throw new ScriptException("Both script file and script text are empty for element:" + this.getName());
        }
        catch (ScriptException ex) {
            Throwable rootCause = ex.getCause();
            if (!this.isStopCondition(rootCause)) throw ex;
            throw (RuntimeException)ex.getCause();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public boolean compile() throws ScriptException, IOException {
        boolean supportsCompilable;
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        boolean bl = supportsCompilable = scriptEngine instanceof Compilable && !"bsh.engine.BshScriptEngine".equals(scriptEngine.getClass().getName());
        if (!supportsCompilable) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)this.getScript())) {
            try {
                ((Compilable)((Object)scriptEngine)).compile(this.getScript());
                return true;
            }
            catch (ScriptException e) {
                logger.error("Error compiling script for test element {}, error:{}", (Object)this.getName(), (Object)e.getMessage());
                return false;
            }
        }
        File scriptFile = new File(this.getFilename());
        Throwable throwable = null;
        try (BufferedReader fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());){
            ((Compilable)((Object)scriptEngine)).compile(fileReader);
            boolean bl2 = true;
            return bl2;
        }
        catch (ScriptException e) {
            logger.error("Error compiling script for test element {}, error:{}", (Object)this.getName(), (Object)e.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void computeScriptMD5() {
        if (this.scriptMd5 == null) {
            this.scriptMd5 = DigestUtils.md5Hex((String)this.getScript());
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void testStarted() {
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        compiledScriptsCache.clear();
        this.scriptMd5 = null;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }
}

