/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.org.pcollections;

import io.micrometer.shaded.org.pcollections.IntTreePMap;
import io.micrometer.shaded.org.pcollections.PVector;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TreePVector<E>
extends AbstractList<E>
implements PVector<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TreePVector<Object> EMPTY = new TreePVector(IntTreePMap.empty());
    private final IntTreePMap<E> map;

    public static <E> TreePVector<E> empty() {
        return EMPTY;
    }

    public static <E> TreePVector<E> singleton(E e) {
        return TreePVector.empty().plus((Object)e);
    }

    public static <E> TreePVector<E> from(Collection<? extends E> list) {
        if (list instanceof TreePVector) {
            return (TreePVector)list;
        }
        return TreePVector.empty().plusAll((Collection)list);
    }

    private TreePVector(IntTreePMap<E> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.map.get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public TreePVector<E> subList(int start, int end) {
        int size = this.size();
        if (start < 0 || end > size || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return TreePVector.empty();
        }
        if (start == 0) {
            if (end == size) {
                return this;
            }
            return ((TreePVector)this.minus(size - 1)).subList(start, end);
        }
        return ((TreePVector)this.minus(0)).subList(start - 1, end - 1);
    }

    @Override
    public TreePVector<E> plus(E e) {
        return new TreePVector<E>(this.map.plus(this.size(), e));
    }

    @Override
    public TreePVector<E> plus(int i, E e) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector<E>(this.map.withKeysChangedAbove(i, 1).plus(i, e));
    }

    @Override
    public TreePVector<E> minus(Object e) {
        for (Map.Entry<Integer, E> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(e)) continue;
            return this.minus(entry.getKey());
        }
        return this;
    }

    @Override
    public TreePVector<E> minus(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector(((IntTreePMap)this.map.minus(i)).withKeysChangedAbove(i, -1));
    }

    @Override
    public TreePVector<E> plusAll(Collection<? extends E> list) {
        PVector<E> result = this;
        for (E e : list) {
            result = result.plus((Object)e);
        }
        return result;
    }

    @Override
    public TreePVector<E> minusAll(Collection<?> list) {
        PVector<E> result = this;
        for (Object e : list) {
            result = result.minus(e);
        }
        return result;
    }

    @Override
    public TreePVector<E> plusAll(int i, Collection<? extends E> list) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (list.size() == 0) {
            return this;
        }
        IntTreePMap<E> map = this.map.withKeysChangedAbove(i, list.size());
        for (E e : list) {
            map = map.plus(i++, e);
        }
        return new TreePVector<E>(map);
    }

    @Override
    public PVector<E> with(int i, E e) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        IntTreePMap<E> map = this.map.plus(i, e);
        if (map == this.map) {
            return this;
        }
        return new TreePVector<E>(map);
    }
}

