/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.GcGenerationAge;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
@NonNullFields
public class JvmGcMetrics
implements MeterBinder {
    private static final Logger logger = LoggerFactory.getLogger(JvmGcMetrics.class);
    private boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    private Iterable<Tag> tags;
    @Nullable
    private String youngGenPoolName;
    @Nullable
    private String oldGenPoolName;

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (this.isYoungGenPool(mbean.getName())) {
                this.youngGenPoolName = mbean.getName();
            }
            if (!this.isOldGenPool(mbean.getName())) continue;
            this.oldGenPoolName = mbean.getName();
        }
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        AtomicLong maxDataSize = new AtomicLong(0L);
        Gauge.builder("jvm.gc.max.data.size", maxDataSize, AtomicLong::get).tags(this.tags).description("Max size of old generation memory pool").baseUnit("bytes").register(registry);
        AtomicLong liveDataSize = new AtomicLong(0L);
        Gauge.builder("jvm.gc.live.data.size", liveDataSize, AtomicLong::get).tags(this.tags).description("Size of old generation memory pool after a full GC").baseUnit("bytes").register(registry);
        Counter promotedBytes = Counter.builder("jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(registry);
        Counter allocatedBytes = Counter.builder("jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the young generation memory pool after one GC to before the next").register(registry);
        if (this.managementExtensionsPresent) {
            AtomicLong youngGenSizeAfter = new AtomicLong(0L);
            for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (!(mbean instanceof NotificationEmitter)) continue;
                ((NotificationEmitter)((Object)mbean)).addNotificationListener((notification, ref) -> {
                    String type = notification.getType();
                    if (type.equals("com.sun.management.gc.notification")) {
                        long delta;
                        CompositeData cd = (CompositeData)notification.getUserData();
                        GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                        if (this.isConcurrentPhase(notificationInfo.getGcCause())) {
                            Timer.builder("jvm.gc.concurrent.phase.time").tags(this.tags).tags("action", notificationInfo.getGcAction(), "cause", notificationInfo.getGcCause()).description("Time spent in concurrent phase").register(registry).record(notificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                        } else {
                            Timer.builder("jvm.gc.pause").tags(this.tags).tags("action", notificationInfo.getGcAction(), "cause", notificationInfo.getGcCause()).description("Time spent in GC pause").register(registry).record(notificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                        }
                        GcInfo gcInfo = notificationInfo.getGcInfo();
                        Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                        Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                        if (this.oldGenPoolName != null) {
                            long oldBefore = before.get(this.oldGenPoolName).getUsed();
                            long oldAfter = after.get(this.oldGenPoolName).getUsed();
                            delta = oldAfter - oldBefore;
                            if (delta > 0L) {
                                promotedBytes.increment(delta);
                            }
                            if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                                liveDataSize.set(oldAfter);
                                long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                                maxDataSize.set(oldMaxAfter);
                            }
                        }
                        if (this.youngGenPoolName != null) {
                            long youngBefore = before.get(this.youngGenPoolName).getUsed();
                            long youngAfter = after.get(this.youngGenPoolName).getUsed();
                            delta = youngBefore - youngGenSizeAfter.get();
                            youngGenSizeAfter.set(youngAfter);
                            if (delta > 0L) {
                                allocatedBytes.increment(delta);
                            }
                        }
                    }
                }, null, null);
            }
        }
    }

    private static boolean isManagementExtensionsPresent() {
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, JvmGcMetrics.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            logger.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    private boolean isConcurrentPhase(String cause) {
        return "No GC".equals(cause);
    }

    private boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }
}

