/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.prometheus.PrometheusConfig;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MicrometerCollector
extends Collector {
    private final Meter.Id id;
    private final List<Child> children = new CopyOnWriteArrayList<Child>();
    private final String conventionName;
    private final List<String> tagKeys;
    private final PrometheusConfig config;

    public MicrometerCollector(Meter.Id id, NamingConvention convention, PrometheusConfig config) {
        this.id = id;
        this.conventionName = id.getConventionName(convention);
        this.tagKeys = id.getConventionTags(convention).stream().map(Tag::getKey).collect(Collectors.toList());
        this.config = config;
    }

    public void add(Child child) {
        this.children.add(child);
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public List<Collector.MetricFamilySamples> collect() {
        String help = this.config.descriptions() ? Optional.ofNullable(this.id.getDescription()).orElse(" ") : " ";
        HashMap families = new HashMap();
        for (Child child : this.children) {
            child.samples(this.conventionName, this.tagKeys).forEach(family -> families.compute(family.getConventionName(), (name, matchingFamily) -> matchingFamily != null ? matchingFamily.addSamples(family.samples) : family));
        }
        return families.values().stream().map(family -> new Collector.MetricFamilySamples(family.conventionName, family.type, help, family.samples)).collect(Collectors.toList());
    }

    static class Family {
        final Collector.Type type;
        final String conventionName;
        final List<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();

        Family(Collector.Type type, String conventionName, Collector.MetricFamilySamples.Sample ... samples) {
            this.type = type;
            this.conventionName = conventionName;
            Collections.addAll(this.samples, samples);
        }

        Family(Collector.Type type, String conventionName, Stream<Collector.MetricFamilySamples.Sample> samples) {
            this.type = type;
            this.conventionName = conventionName;
            samples.forEach(this.samples::add);
        }

        String getConventionName() {
            return this.conventionName;
        }

        Family addSamples(Collection<Collector.MetricFamilySamples.Sample> samples) {
            this.samples.addAll(samples);
            return this;
        }
    }

    static interface Child {
        public Stream<Family> samples(String var1, List<String> var2);
    }
}

