/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.prometheus;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusProperties;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusScrapeEndpoint;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusScrapeMvcEndpoint;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
@Import(value={StringToDurationConverter.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig prometheusConfig(PrometheusProperties props) {
        return new PrometheusPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Configuration
    @ConditionalOnClass(value={PushGateway.class})
    @ConditionalOnProperty(prefix="management.metrics.export.prometheus.pushgateway", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @Incubating(since="1.0.0")
    public static class PrometheusPushGatewayConfiguration {
        @Bean
        public PushGatewayHandler pushGatewayHandler(CollectorRegistry collectorRegistry, PrometheusProperties prometheusProperties, Environment environment) {
            return new PushGatewayHandler(collectorRegistry, prometheusProperties, environment);
        }

        public static class PushGatewayHandler {
            private final Logger logger = LoggerFactory.getLogger(PrometheusPushGatewayConfiguration.class);
            private final CollectorRegistry collectorRegistry;
            private final PrometheusProperties.PushgatewayProperties pushgatewayProperties;
            private final PushGateway pushGateway;
            private final Environment environment;
            private final ScheduledExecutorService executorService;

            public PushGatewayHandler(CollectorRegistry collectorRegistry, PrometheusProperties prometheusProperties, Environment environment) {
                this.collectorRegistry = collectorRegistry;
                this.pushgatewayProperties = prometheusProperties.getPushgateway();
                this.pushGateway = new PushGateway(this.pushgatewayProperties.getBaseUrl());
                this.environment = environment;
                this.executorService = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName("micrometer-pushgateway");
                    return thread;
                });
                this.executorService.scheduleAtFixedRate(this::push, 0L, this.pushgatewayProperties.getPushRate().toMillis(), TimeUnit.MILLISECONDS);
            }

            void push() {
                try {
                    this.pushGateway.pushAdd(this.collectorRegistry, this.job(), this.pushgatewayProperties.getGroupingKeys());
                }
                catch (UnknownHostException e) {
                    this.logger.error("Unable to locate host '" + this.pushgatewayProperties.getBaseUrl() + "'. No longer attempting metrics publication to this host");
                    this.executorService.shutdown();
                }
                catch (Throwable t) {
                    this.logger.error("Unable to push metrics to Prometheus Pushgateway", t);
                }
            }

            @PreDestroy
            void shutdown() {
                this.executorService.shutdown();
                if (this.pushgatewayProperties.isPushOnShutdown()) {
                    this.push();
                }
                if (this.pushgatewayProperties.isDeleteOnShutdown()) {
                    try {
                        this.pushGateway.delete(this.job(), this.pushgatewayProperties.getGroupingKeys());
                    }
                    catch (Throwable t) {
                        this.logger.error("Unable to delete metrics from Prometheus Pushgateway", t);
                    }
                }
            }

            private String job() {
                String job = this.pushgatewayProperties.getJob();
                if (job == null) {
                    job = this.environment.getProperty("spring.application.name");
                }
                if (job == null) {
                    job = "spring";
                }
                return job;
            }
        }
    }

    @ManagementContextConfiguration
    @ConditionalOnClass(value={AbstractEndpoint.class})
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }

        @Bean
        @ConditionalOnEnabledEndpoint(value="prometheus")
        public PrometheusScrapeMvcEndpoint prometheusMvcEndpoint(PrometheusScrapeEndpoint delegate) {
            return new PrometheusScrapeMvcEndpoint(delegate);
        }
    }
}

