/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class SystemMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"management.metrics.binders.uptime.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean
    public UptimeMetrics uptimeMetrics() {
        return new UptimeMetrics();
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.binders.processor.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean
    public ProcessorMetrics processorMetrics() {
        return new ProcessorMetrics();
    }

    @Bean
    @ConditionalOnProperty(name={"management.metrics.binders.files.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean
    public FileDescriptorMetrics fileDescriptorMetrics() {
        return new FileDescriptorMetrics();
    }
}

