/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.dynatrace;

import io.micrometer.core.instrument.Clock;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.DynatraceMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.dynatrace.DynatraceProperties;
import io.micrometer.spring.autoconfigure.export.dynatrace.DynatracePropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={DynatraceMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.dynatrace", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={DynatraceProperties.class})
@Import(value={StringToDurationConverter.class})
public class DynatraceMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DynatraceConfig dynatraceConfig(DynatraceProperties props) {
        return new DynatracePropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public DynatraceMeterRegistry dynatraceMeterRegistry(DynatraceConfig config, Clock clock) {
        return new DynatraceMeterRegistry(config, clock);
    }
}

