/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class GetFlushStateParam {
    private final List<Long> segmentIDs;
    private final String collectionName;
    private final Long flushTs;

    private GetFlushStateParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.segmentIDs = builder.segmentIDs;
        this.collectionName = builder.collectionName;
        this.flushTs = builder.flushTs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "GetFlushStateParam{collectionName='" + this.collectionName + '\'' + ", flushTs=" + this.flushTs + '}';
    }

    public List<Long> getSegmentIDs() {
        return this.segmentIDs;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Long getFlushTs() {
        return this.flushTs;
    }

    public static final class Builder {
        private final List<Long> segmentIDs = new ArrayList<Long>();
        private String collectionName;
        private Long flushTs = 0L;

        private Builder() {
        }

        @Deprecated
        public Builder withSegmentIDs(@NonNull List<Long> segmentIDs) {
            if (segmentIDs == null) {
                throw new NullPointerException("segmentIDs is marked non-null but is null");
            }
            this.segmentIDs.addAll(segmentIDs);
            return this;
        }

        @Deprecated
        public Builder addSegmentID(@NonNull Long segmentID) {
            if (segmentID == null) {
                throw new NullPointerException("segmentID is marked non-null but is null");
            }
            this.segmentIDs.add(segmentID);
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFlushTs(@NonNull Long flushTs) {
            if (flushTs == null) {
                throw new NullPointerException("flushTs is marked non-null but is null");
            }
            this.flushTs = flushTs;
            return this;
        }

        public GetFlushStateParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetFlushStateParam(this);
        }
    }
}

