/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.partition;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class CreatePartitionParam {
    private final String collectionName;
    private final String partitionName;

    private CreatePartitionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CreatePartitionParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public static final class Builder {
        private String collectionName;
        private String partitionName;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public CreatePartitionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.partitionName, "Partition name");
            return new CreatePartitionParam(this);
        }
    }
}

