/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class ConnectConfig {
    @NonNull
    private String uri;
    private String token;
    private String username;
    private String password;
    private String dbName;
    private long connectTimeoutMs;
    private long keepAliveTimeMs;
    private long keepAliveTimeoutMs;
    private boolean keepAliveWithoutCalls;
    private long rpcDeadlineMs;
    private String clientKeyPath;
    private String clientPemPath;
    private String caPemPath;
    private String serverPemPath;
    private String serverName;
    private Boolean secure;
    private long idleTimeoutMs;

    public String getHost() {
        URI uri = URI.create(this.uri);
        return uri.getHost();
    }

    public int getPort() {
        URI uri = URI.create(this.uri);
        return uri.getPort();
    }

    public String getAuthorization() {
        if (this.token != null) {
            return this.token;
        }
        if (this.username != null && this.password != null) {
            return this.username + ":" + this.password;
        }
        return null;
    }

    public Boolean isSecure() {
        if (this.secure != null) {
            return this.secure;
        }
        if (this.token == null && this.username == null && this.password == null) {
            return false;
        }
        return this.token == null || !this.token.isEmpty();
    }

    private static long $default$connectTimeoutMs() {
        return 10000L;
    }

    private static long $default$keepAliveTimeMs() {
        return 55000L;
    }

    private static long $default$keepAliveTimeoutMs() {
        return 20000L;
    }

    private static boolean $default$keepAliveWithoutCalls() {
        return false;
    }

    private static long $default$rpcDeadlineMs() {
        return 0L;
    }

    private static long $default$idleTimeoutMs() {
        return TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    }

    protected ConnectConfig(ConnectConfigBuilder<?, ?> b) {
        this.uri = ((ConnectConfigBuilder)b).uri;
        if (this.uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.token = ((ConnectConfigBuilder)b).token;
        this.username = ((ConnectConfigBuilder)b).username;
        this.password = ((ConnectConfigBuilder)b).password;
        this.dbName = ((ConnectConfigBuilder)b).dbName;
        this.connectTimeoutMs = ((ConnectConfigBuilder)b).connectTimeoutMs$set ? ((ConnectConfigBuilder)b).connectTimeoutMs$value : ConnectConfig.$default$connectTimeoutMs();
        this.keepAliveTimeMs = ((ConnectConfigBuilder)b).keepAliveTimeMs$set ? ((ConnectConfigBuilder)b).keepAliveTimeMs$value : ConnectConfig.$default$keepAliveTimeMs();
        this.keepAliveTimeoutMs = ((ConnectConfigBuilder)b).keepAliveTimeoutMs$set ? ((ConnectConfigBuilder)b).keepAliveTimeoutMs$value : ConnectConfig.$default$keepAliveTimeoutMs();
        this.keepAliveWithoutCalls = ((ConnectConfigBuilder)b).keepAliveWithoutCalls$set ? ((ConnectConfigBuilder)b).keepAliveWithoutCalls$value : ConnectConfig.$default$keepAliveWithoutCalls();
        this.rpcDeadlineMs = ((ConnectConfigBuilder)b).rpcDeadlineMs$set ? ((ConnectConfigBuilder)b).rpcDeadlineMs$value : ConnectConfig.$default$rpcDeadlineMs();
        this.clientKeyPath = ((ConnectConfigBuilder)b).clientKeyPath;
        this.clientPemPath = ((ConnectConfigBuilder)b).clientPemPath;
        this.caPemPath = ((ConnectConfigBuilder)b).caPemPath;
        this.serverPemPath = ((ConnectConfigBuilder)b).serverPemPath;
        this.serverName = ((ConnectConfigBuilder)b).serverName;
        this.secure = ((ConnectConfigBuilder)b).secure;
        this.idleTimeoutMs = ((ConnectConfigBuilder)b).idleTimeoutMs$set ? ((ConnectConfigBuilder)b).idleTimeoutMs$value : ConnectConfig.$default$idleTimeoutMs();
    }

    public static ConnectConfigBuilder<?, ?> builder() {
        return new ConnectConfigBuilderImpl();
    }

    @NonNull
    public String getUri() {
        return this.uri;
    }

    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long getKeepAliveTimeMs() {
        return this.keepAliveTimeMs;
    }

    public long getKeepAliveTimeoutMs() {
        return this.keepAliveTimeoutMs;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getRpcDeadlineMs() {
        return this.rpcDeadlineMs;
    }

    public String getClientKeyPath() {
        return this.clientKeyPath;
    }

    public String getClientPemPath() {
        return this.clientPemPath;
    }

    public String getCaPemPath() {
        return this.caPemPath;
    }

    public String getServerPemPath() {
        return this.serverPemPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public void setUri(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = uri;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setConnectTimeoutMs(long connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setKeepAliveTimeMs(long keepAliveTimeMs) {
        this.keepAliveTimeMs = keepAliveTimeMs;
    }

    public void setKeepAliveTimeoutMs(long keepAliveTimeoutMs) {
        this.keepAliveTimeoutMs = keepAliveTimeoutMs;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public void setRpcDeadlineMs(long rpcDeadlineMs) {
        this.rpcDeadlineMs = rpcDeadlineMs;
    }

    public void setClientKeyPath(String clientKeyPath) {
        this.clientKeyPath = clientKeyPath;
    }

    public void setClientPemPath(String clientPemPath) {
        this.clientPemPath = clientPemPath;
    }

    public void setCaPemPath(String caPemPath) {
        this.caPemPath = caPemPath;
    }

    public void setServerPemPath(String serverPemPath) {
        this.serverPemPath = serverPemPath;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectConfig)) {
            return false;
        }
        ConnectConfig other = (ConnectConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        if (this.getKeepAliveTimeMs() != other.getKeepAliveTimeMs()) {
            return false;
        }
        if (this.getKeepAliveTimeoutMs() != other.getKeepAliveTimeoutMs()) {
            return false;
        }
        if (this.isKeepAliveWithoutCalls() != other.isKeepAliveWithoutCalls()) {
            return false;
        }
        if (this.getRpcDeadlineMs() != other.getRpcDeadlineMs()) {
            return false;
        }
        if (this.getIdleTimeoutMs() != other.getIdleTimeoutMs()) {
            return false;
        }
        Boolean this$secure = this.getSecure();
        Boolean other$secure = other.getSecure();
        if (this$secure == null ? other$secure != null : !((Object)this$secure).equals(other$secure)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$clientKeyPath = this.getClientKeyPath();
        String other$clientKeyPath = other.getClientKeyPath();
        if (this$clientKeyPath == null ? other$clientKeyPath != null : !this$clientKeyPath.equals(other$clientKeyPath)) {
            return false;
        }
        String this$clientPemPath = this.getClientPemPath();
        String other$clientPemPath = other.getClientPemPath();
        if (this$clientPemPath == null ? other$clientPemPath != null : !this$clientPemPath.equals(other$clientPemPath)) {
            return false;
        }
        String this$caPemPath = this.getCaPemPath();
        String other$caPemPath = other.getCaPemPath();
        if (this$caPemPath == null ? other$caPemPath != null : !this$caPemPath.equals(other$caPemPath)) {
            return false;
        }
        String this$serverPemPath = this.getServerPemPath();
        String other$serverPemPath = other.getServerPemPath();
        if (this$serverPemPath == null ? other$serverPemPath != null : !this$serverPemPath.equals(other$serverPemPath)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        return !(this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $connectTimeoutMs = this.getConnectTimeoutMs();
        result = result * 59 + (int)($connectTimeoutMs >>> 32 ^ $connectTimeoutMs);
        long $keepAliveTimeMs = this.getKeepAliveTimeMs();
        result = result * 59 + (int)($keepAliveTimeMs >>> 32 ^ $keepAliveTimeMs);
        long $keepAliveTimeoutMs = this.getKeepAliveTimeoutMs();
        result = result * 59 + (int)($keepAliveTimeoutMs >>> 32 ^ $keepAliveTimeoutMs);
        result = result * 59 + (this.isKeepAliveWithoutCalls() ? 79 : 97);
        long $rpcDeadlineMs = this.getRpcDeadlineMs();
        result = result * 59 + (int)($rpcDeadlineMs >>> 32 ^ $rpcDeadlineMs);
        long $idleTimeoutMs = this.getIdleTimeoutMs();
        result = result * 59 + (int)($idleTimeoutMs >>> 32 ^ $idleTimeoutMs);
        Boolean $secure = this.getSecure();
        result = result * 59 + ($secure == null ? 43 : ((Object)$secure).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $clientKeyPath = this.getClientKeyPath();
        result = result * 59 + ($clientKeyPath == null ? 43 : $clientKeyPath.hashCode());
        String $clientPemPath = this.getClientPemPath();
        result = result * 59 + ($clientPemPath == null ? 43 : $clientPemPath.hashCode());
        String $caPemPath = this.getCaPemPath();
        result = result * 59 + ($caPemPath == null ? 43 : $caPemPath.hashCode());
        String $serverPemPath = this.getServerPemPath();
        result = result * 59 + ($serverPemPath == null ? 43 : $serverPemPath.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        return result;
    }

    public String toString() {
        return "ConnectConfig(uri=" + this.getUri() + ", token=" + this.getToken() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", keepAliveTimeMs=" + this.getKeepAliveTimeMs() + ", keepAliveTimeoutMs=" + this.getKeepAliveTimeoutMs() + ", keepAliveWithoutCalls=" + this.isKeepAliveWithoutCalls() + ", rpcDeadlineMs=" + this.getRpcDeadlineMs() + ", clientKeyPath=" + this.getClientKeyPath() + ", clientPemPath=" + this.getClientPemPath() + ", caPemPath=" + this.getCaPemPath() + ", serverPemPath=" + this.getServerPemPath() + ", serverName=" + this.getServerName() + ", secure=" + this.getSecure() + ", idleTimeoutMs=" + this.getIdleTimeoutMs() + ")";
    }

    private static final class ConnectConfigBuilderImpl
    extends ConnectConfigBuilder<ConnectConfig, ConnectConfigBuilderImpl> {
        private ConnectConfigBuilderImpl() {
        }

        @Override
        protected ConnectConfigBuilderImpl self() {
            return this;
        }

        @Override
        public ConnectConfig build() {
            return new ConnectConfig(this);
        }
    }

    public static abstract class ConnectConfigBuilder<C extends ConnectConfig, B extends ConnectConfigBuilder<C, B>> {
        private String uri;
        private String token;
        private String username;
        private String password;
        private String dbName;
        private boolean connectTimeoutMs$set;
        private long connectTimeoutMs$value;
        private boolean keepAliveTimeMs$set;
        private long keepAliveTimeMs$value;
        private boolean keepAliveTimeoutMs$set;
        private long keepAliveTimeoutMs$value;
        private boolean keepAliveWithoutCalls$set;
        private boolean keepAliveWithoutCalls$value;
        private boolean rpcDeadlineMs$set;
        private long rpcDeadlineMs$value;
        private String clientKeyPath;
        private String clientPemPath;
        private String caPemPath;
        private String serverPemPath;
        private String serverName;
        private Boolean secure;
        private boolean idleTimeoutMs$set;
        private long idleTimeoutMs$value;

        protected abstract B self();

        public abstract C build();

        public B uri(@NonNull String uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.uri = uri;
            return this.self();
        }

        public B token(String token) {
            this.token = token;
            return this.self();
        }

        public B username(String username) {
            this.username = username;
            return this.self();
        }

        public B password(String password) {
            this.password = password;
            return this.self();
        }

        public B dbName(String dbName) {
            this.dbName = dbName;
            return this.self();
        }

        public B connectTimeoutMs(long connectTimeoutMs) {
            this.connectTimeoutMs$value = connectTimeoutMs;
            this.connectTimeoutMs$set = true;
            return this.self();
        }

        public B keepAliveTimeMs(long keepAliveTimeMs) {
            this.keepAliveTimeMs$value = keepAliveTimeMs;
            this.keepAliveTimeMs$set = true;
            return this.self();
        }

        public B keepAliveTimeoutMs(long keepAliveTimeoutMs) {
            this.keepAliveTimeoutMs$value = keepAliveTimeoutMs;
            this.keepAliveTimeoutMs$set = true;
            return this.self();
        }

        public B keepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
            this.keepAliveWithoutCalls$value = keepAliveWithoutCalls;
            this.keepAliveWithoutCalls$set = true;
            return this.self();
        }

        public B rpcDeadlineMs(long rpcDeadlineMs) {
            this.rpcDeadlineMs$value = rpcDeadlineMs;
            this.rpcDeadlineMs$set = true;
            return this.self();
        }

        public B clientKeyPath(String clientKeyPath) {
            this.clientKeyPath = clientKeyPath;
            return this.self();
        }

        public B clientPemPath(String clientPemPath) {
            this.clientPemPath = clientPemPath;
            return this.self();
        }

        public B caPemPath(String caPemPath) {
            this.caPemPath = caPemPath;
            return this.self();
        }

        public B serverPemPath(String serverPemPath) {
            this.serverPemPath = serverPemPath;
            return this.self();
        }

        public B serverName(String serverName) {
            this.serverName = serverName;
            return this.self();
        }

        public B secure(Boolean secure) {
            this.secure = secure;
            return this.self();
        }

        public B idleTimeoutMs(long idleTimeoutMs) {
            this.idleTimeoutMs$value = idleTimeoutMs;
            this.idleTimeoutMs$set = true;
            return this.self();
        }

        public String toString() {
            return "ConnectConfig.ConnectConfigBuilder(uri=" + this.uri + ", token=" + this.token + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", connectTimeoutMs$value=" + this.connectTimeoutMs$value + ", keepAliveTimeMs$value=" + this.keepAliveTimeMs$value + ", keepAliveTimeoutMs$value=" + this.keepAliveTimeoutMs$value + ", keepAliveWithoutCalls$value=" + this.keepAliveWithoutCalls$value + ", rpcDeadlineMs$value=" + this.rpcDeadlineMs$value + ", clientKeyPath=" + this.clientKeyPath + ", clientPemPath=" + this.clientPemPath + ", caPemPath=" + this.caPemPath + ", serverPemPath=" + this.serverPemPath + ", serverName=" + this.serverName + ", secure=" + this.secure + ", idleTimeoutMs$value=" + this.idleTimeoutMs$value + ")";
        }
    }
}

