/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.Status;
import io.milvus.v2.exception.MilvusClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcUtils {
    protected static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);

    public void handleResponse(String requestInfo, Status status) {
        if (status.getCode() != 0 || !status.getErrorCode().equals((Object)ErrorCode.Success)) {
            int code = status.getCode();
            if (code == 0) {
                code = status.getErrorCode().getNumber();
            }
            logger.error("{} failed, error code: {}, reason: {}", new Object[]{requestInfo, io.milvus.v2.exception.ErrorCode.SERVER_ERROR.getCode(), status.getReason()});
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, status.getReason());
        }
        logger.debug("{} successfully!", (Object)requestInfo);
    }
}

