/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.connect;

import io.milvus.bulkwriter.connect.StorageConnectParam;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class S3ConnectParam
extends StorageConnectParam {
    private final String bucketName;
    private final String endpoint;
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;
    private final String region;
    private final OkHttpClient httpClient;
    private final String cloudName;

    private S3ConnectParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.bucketName = builder.bucketName;
        this.endpoint = builder.endpoint;
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.region = builder.region;
        this.httpClient = builder.httpClient;
        this.cloudName = builder.cloudName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String toString() {
        return "S3ConnectParam(bucketName=" + this.getBucketName() + ", endpoint=" + this.getEndpoint() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", sessionToken=" + this.getSessionToken() + ", region=" + this.getRegion() + ", httpClient=" + this.getHttpClient() + ", cloudName=" + this.getCloudName() + ")";
    }

    public static final class Builder {
        private String bucketName;
        private String endpoint;
        private String accessKey;
        private String secretKey;
        private String sessionToken;
        private String region;
        private OkHttpClient httpClient;
        private String cloudName;

        private Builder() {
        }

        public Builder withCloudName(@NotNull String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        public Builder withBucketName(@NonNull String bucketName) {
            if (bucketName == null) {
                throw new NullPointerException("bucketName is marked non-null but is null");
            }
            this.bucketName = bucketName;
            return this;
        }

        public Builder withEndpoint(@NonNull String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder withAccessKey(@NonNull String accessKey) {
            if (accessKey == null) {
                throw new NullPointerException("accessKey is marked non-null but is null");
            }
            this.accessKey = accessKey;
            return this;
        }

        public Builder withSecretKey(@NonNull String secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.secretKey = secretKey;
            return this;
        }

        public Builder withSessionToken(@NonNull String sessionToken) {
            if (sessionToken == null) {
                throw new NullPointerException("sessionToken is marked non-null but is null");
            }
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder withRegion(@NonNull String region) {
            if (region == null) {
                throw new NullPointerException("region is marked non-null but is null");
            }
            this.region = region;
            return this;
        }

        public Builder withHttpClient(@NonNull OkHttpClient httpClient) {
            if (httpClient == null) {
                throw new NullPointerException("httpClient is marked non-null but is null");
            }
            this.httpClient = httpClient;
            return this;
        }

        public S3ConnectParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.endpoint, "endpoint");
            ParamUtils.CheckNullEmptyString(this.bucketName, "bucketName");
            return new S3ConnectParam(this);
        }
    }
}

