/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.dml.InsertParam;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class InsertRowsParam {
    private final InsertParam insertParam;

    private InsertRowsParam(InsertParam insertParam) {
        this.insertParam = insertParam;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public InsertParam getInsertParam() {
        return this.insertParam;
    }

    public String toString() {
        return "InsertRowsParam(insertParam=" + this.getInsertParam() + ")";
    }

    public static class Builder {
        private String collectionName;
        private List<JsonObject> rows;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withRows(@NonNull List<JsonObject> rows) {
            if (rows == null) {
                throw new NullPointerException("rows is marked non-null but is null");
            }
            this.rows = rows;
            return this;
        }

        public InsertRowsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.rows)) {
                throw new ParamException("Rows cannot be empty");
            }
            InsertParam insertParam = InsertParam.newBuilder().withCollectionName(this.collectionName).withRows(this.rows).build();
            return new InsertRowsParam(insertParam);
        }
    }
}

