/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.rbac;

import io.milvus.grpc.CreateRoleRequest;
import io.milvus.grpc.DropRoleRequest;
import io.milvus.grpc.GrantEntity;
import io.milvus.grpc.GrantorEntity;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ObjectEntity;
import io.milvus.grpc.OperatePrivilegeRequest;
import io.milvus.grpc.OperatePrivilegeType;
import io.milvus.grpc.OperateUserRoleRequest;
import io.milvus.grpc.OperateUserRoleType;
import io.milvus.grpc.PrivilegeEntity;
import io.milvus.grpc.RoleEntity;
import io.milvus.grpc.SelectGrantRequest;
import io.milvus.grpc.SelectGrantResponse;
import io.milvus.grpc.SelectRoleRequest;
import io.milvus.grpc.SelectRoleResponse;
import io.milvus.grpc.Status;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import java.util.List;
import java.util.stream.Collectors;

public class RoleService
extends BaseService {
    public List<String> listRoles(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "listRoles";
        SelectRoleRequest request = SelectRoleRequest.newBuilder().build();
        SelectRoleResponse response = blockingStub.selectRole(request);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getResultsList().stream().map(roleResult -> roleResult.getRole().getName()).collect(Collectors.toList());
    }

    public Void createRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateRoleReq request) {
        String title = "createRole";
        CreateRoleRequest createRoleRequest = CreateRoleRequest.newBuilder().setEntity(RoleEntity.newBuilder().setName(request.getRoleName()).build()).build();
        Status status = blockingStub.createRole(createRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public DescribeRoleResp describeRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeRoleReq request) {
        String title = "describeRole";
        SelectGrantRequest selectGrantRequest = SelectGrantRequest.newBuilder().setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).build()).build();
        SelectGrantResponse response = blockingStub.selectGrant(selectGrantRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object describeRoleResp = ((DescribeRoleResp.DescribeRoleRespBuilder)DescribeRoleResp.builder().grantInfos(response.getEntitiesList().stream().map(grantEntity -> ((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)((DescribeRoleResp.GrantInfo.GrantInfoBuilder)DescribeRoleResp.GrantInfo.builder().dbName(grantEntity.getDbName())).objectName(grantEntity.getObjectName())).objectType(grantEntity.getObject().getName())).privilege(grantEntity.getGrantor().getPrivilege().getName())).grantor(grantEntity.getGrantor().getUser().getName())).build()).collect(Collectors.toList()))).build();
        return describeRoleResp;
    }

    public Void dropRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropRoleReq request) {
        String title = "dropRole";
        DropRoleRequest dropRoleRequest = DropRoleRequest.newBuilder().setRoleName(request.getRoleName()).build();
        Status status = blockingStub.dropRole(dropRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void grantPrivilege(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GrantPrivilegeReq request) {
        String title = "grantPrivilege";
        GrantEntity entity = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setObjectName(request.getObjectName()).setObject(ObjectEntity.newBuilder().setName(request.getObjectType()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).build();
        OperatePrivilegeRequest operatePrivilegeRequest = OperatePrivilegeRequest.newBuilder().setEntity(entity).setType(OperatePrivilegeType.Grant).build();
        Status status = blockingStub.operatePrivilege(operatePrivilegeRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void revokePrivilege(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RevokePrivilegeReq request) {
        String title = "revokePrivilege";
        GrantEntity entity = GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(request.getRoleName()).build()).setObjectName(request.getObjectName()).setObject(ObjectEntity.newBuilder().setName(request.getObjectType()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(request.getPrivilege()).build()).build()).build();
        OperatePrivilegeRequest operatePrivilegeRequest = OperatePrivilegeRequest.newBuilder().setEntity(entity).setType(OperatePrivilegeType.Revoke).build();
        Status status = blockingStub.operatePrivilege(operatePrivilegeRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void grantRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GrantRoleReq request) {
        String title = "grantRole";
        OperateUserRoleRequest operateUserRoleRequest = OperateUserRoleRequest.newBuilder().setUsername(request.getUserName()).setRoleName(request.getRoleName()).setType(OperateUserRoleType.AddUserToRole).build();
        Status status = blockingStub.operateUserRole(operateUserRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void revokeRole(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RevokeRoleReq request) {
        String title = "grantRole";
        OperateUserRoleRequest operateUserRoleRequest = OperateUserRoleRequest.newBuilder().setUsername(request.getUserName()).setRoleName(request.getRoleName()).setType(OperateUserRoleType.RemoveUserFromRole).build();
        Status status = blockingStub.operateUserRole(operateUserRoleRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }
}

