/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.PlaceholderType;
import io.milvus.param.Constant;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.SortedMap;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class SearchIteratorParam {
    private final String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final String metricType;
    private final String vectorFieldName;
    private final int topK;
    private final String expr;
    private final List<String> outFields;
    private final List<?> vectors;
    private final Long NQ;
    private final int roundDecimal;
    private final String params;
    private final long travelTimestamp;
    private final long guaranteeTimestamp;
    private final Long gracefulTime;
    private final ConsistencyLevelEnum consistencyLevel;
    private final boolean ignoreGrowing;
    private final String groupByFieldName;
    private final PlaceholderType plType;
    private final long batchSize;

    private SearchIteratorParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.metricType = builder.metricType.name();
        this.vectorFieldName = builder.vectorFieldName;
        this.topK = builder.topK;
        this.expr = builder.expr;
        this.outFields = builder.outFields;
        this.vectors = builder.vectors;
        this.NQ = builder.NQ;
        this.roundDecimal = builder.roundDecimal;
        this.params = builder.params;
        this.travelTimestamp = builder.travelTimestamp;
        this.guaranteeTimestamp = builder.guaranteeTimestamp;
        this.gracefulTime = builder.gracefulTime;
        this.consistencyLevel = builder.consistencyLevel;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.groupByFieldName = builder.groupByFieldName;
        this.plType = builder.plType;
        this.batchSize = builder.batchSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static void verifyVectors(List<?> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            throw new ParamException("Target vectors can not be empty");
        }
        if (vectors.get(0) instanceof List) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
            List first = (List)vectors.get(0);
            if (!(first.get(0) instanceof Float)) {
                throw new ParamException("Float vector field's value must be Lst<Float>");
            }
        } else if (vectors.get(0) instanceof ByteBuffer) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
        } else if (vectors.get(0) instanceof SortedMap) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
            SortedMap map = (SortedMap)vectors.get(0);
            if (!(map.firstKey() instanceof Long)) {
                throw new ParamException("key type of SparseFloatVector must be Long");
            }
            if (!(map.get(map.firstKey()) instanceof Float)) {
                throw new ParamException("Value type of SparseFloatVector must be Float");
            }
        } else {
            String msg = "Search target vector type is illegal. Only allow List<Float> for FloatVector, ByteBuffer for BinaryVector/Float16Vector/BFloat16Vector, List<SortedMap<Long, Float>> for SparseFloatVector.";
            throw new ParamException(msg);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public Long getNQ() {
        return this.NQ;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public String getParams() {
        return this.params;
    }

    public long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public PlaceholderType getPlType() {
        return this.plType;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public String toString() {
        return "SearchIteratorParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", partitionNames=" + this.getPartitionNames() + ", metricType=" + this.getMetricType() + ", vectorFieldName=" + this.getVectorFieldName() + ", topK=" + this.getTopK() + ", expr=" + this.getExpr() + ", outFields=" + this.getOutFields() + ", vectors=" + this.getVectors() + ", NQ=" + this.getNQ() + ", roundDecimal=" + this.getRoundDecimal() + ", params=" + this.getParams() + ", travelTimestamp=" + this.getTravelTimestamp() + ", guaranteeTimestamp=" + this.getGuaranteeTimestamp() + ", gracefulTime=" + this.getGracefulTime() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ", ignoreGrowing=" + this.isIgnoreGrowing() + ", groupByFieldName=" + this.getGroupByFieldName() + ", plType=" + (Object)((Object)this.getPlType()) + ", batchSize=" + this.getBatchSize() + ")";
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private MetricType metricType = MetricType.None;
        private String vectorFieldName;
        private Integer topK = -1;
        private String expr = "";
        private final List<String> outFields = Lists.newArrayList();
        private List<?> vectors;
        private Long NQ;
        private Integer roundDecimal = -1;
        private String params = "{}";
        private Long travelTimestamp = 0L;
        private Long guaranteeTimestamp = Constant.GUARANTEE_EVENTUALLY_TS;
        private Long gracefulTime = 5000L;
        private ConsistencyLevelEnum consistencyLevel = null;
        private Boolean ignoreGrowing = Boolean.FALSE;
        private String groupByFieldName;
        private PlaceholderType plType = PlaceholderType.None;
        private Long batchSize = 1000L;

        Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withMetricType(@NonNull MetricType metricType) {
            if (metricType == null) {
                throw new NullPointerException("metricType is marked non-null but is null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(@NonNull String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new NullPointerException("vectorFieldName is marked non-null but is null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder withTopK(@NonNull Integer topK) {
            if (topK == null) {
                throw new NullPointerException("topK is marked non-null but is null");
            }
            this.topK = topK;
            return this;
        }

        public Builder withExpr(@NonNull String expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withOutFields(@NonNull List<String> outFields) {
            if (outFields == null) {
                throw new NullPointerException("outFields is marked non-null but is null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        @Deprecated
        public Builder withVectors(@NonNull List<?> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            return this;
        }

        public Builder withFloatVectors(@NonNull List<List<Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.FloatVector;
            return this;
        }

        public Builder withBinaryVectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BinaryVector;
            return this;
        }

        public Builder withFloat16Vectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.Float16Vector;
            return this;
        }

        public Builder withBFloat16Vectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BFloat16Vector;
            return this;
        }

        public Builder withSparseFloatVectors(@NonNull List<SortedMap<Long, Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.SparseFloatVector;
            return this;
        }

        public Builder withRoundDecimal(@NonNull Integer decimal) {
            if (decimal == null) {
                throw new NullPointerException("decimal is marked non-null but is null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withParams(@NonNull String params) {
            if (params == null) {
                throw new NullPointerException("params is marked non-null but is null");
            }
            this.params = params;
            return this;
        }

        public Builder withIgnoreGrowing(@NonNull Boolean ignoreGrowing) {
            if (ignoreGrowing == null) {
                throw new NullPointerException("ignoreGrowing is marked non-null but is null");
            }
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public Builder withGroupByFieldName(@NonNull String groupByFieldName) {
            if (groupByFieldName == null) {
                throw new NullPointerException("groupByFieldName is marked non-null but is null");
            }
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public Builder withBatchSize(@NotNull Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public SearchIteratorParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.topK != -1 && this.topK <= 0) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.travelTimestamp < 0L) {
                throw new ParamException("The travel timestamp must be greater than 0");
            }
            if (this.guaranteeTimestamp < 0L) {
                throw new ParamException("The guarantee timestamp must be greater than 0");
            }
            if (this.metricType == MetricType.None) {
                throw new ParamException("must specify metricType for search iterator");
            }
            SearchIteratorParam.verifyVectors(this.vectors);
            return new SearchIteratorParam(this);
        }
    }
}

