/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class AlterIndexParam {
    private final String collectionName;
    private final String databaseName;
    private final String indexName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterIndexParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.indexName = builder.indexName;
        this.properties.putAll(builder.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "AlterIndexParam(collectionName=" + this.getCollectionName() + ", databaseName=" + this.getDatabaseName() + ", indexName=" + this.getIndexName() + ", properties=" + this.getProperties() + ")";
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;
        private String indexName;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withIndexName(@NonNull String indexName) {
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.indexName = indexName;
            return this;
        }

        public Builder withMMapEnabled(boolean enabledMMap) {
            return this.withProperty("mmap.enabled", Boolean.toString(enabledMMap));
        }

        public Builder withProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.properties.put(key, value);
            return this;
        }

        public AlterIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.indexName, "Index name");
            return new AlterIndexParam(this);
        }
    }
}

