/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

final class HmacSignQuicConnectionIdGenerator
implements QuicConnectionIdGenerator {
    static final QuicConnectionIdGenerator INSTANCE = new HmacSignQuicConnectionIdGenerator();
    private static final String ALGORITM = "HmacSHA256";
    private static final byte[] randomKey = new byte[16];

    private HmacSignQuicConnectionIdGenerator() {
    }

    @Override
    public ByteBuffer newId(int length) {
        throw new UnsupportedOperationException("HmacSignQuicConnectionIdGenerator should always have an input to sign with");
    }

    private static Mac newMac() {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(randomKey, ALGORITM);
            Mac mac = Mac.getInstance(ALGORITM);
            mac.init(keySpec);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public ByteBuffer newId(ByteBuffer buffer, int length) {
        ObjectUtil.checkNotNull((Object)buffer, (String)"buffer");
        ObjectUtil.checkPositive((int)buffer.remaining(), (String)"buffer");
        ObjectUtil.checkInRange((int)length, (int)0, (int)this.maxConnectionIdLength(), (String)"length");
        Mac mac = HmacSignQuicConnectionIdGenerator.newMac();
        mac.update(buffer);
        byte[] signBytes = mac.doFinal();
        if (signBytes.length != length) {
            signBytes = Arrays.copyOf(signBytes, length);
        }
        return ByteBuffer.wrap(signBytes);
    }

    @Override
    public int maxConnectionIdLength() {
        return Quiche.QUICHE_MAX_CONN_ID_LEN;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    static {
        new SecureRandom().nextBytes(randomKey);
    }
}

