/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.JCommander;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerServer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedger {
    private static Logger logger = LoggerFactory.getLogger(DLedger.class);

    public static void main(String[] args) {
        DLedgerConfig dLedgerConfig = new DLedgerConfig();
        JCommander.Builder builder = JCommander.newBuilder().addObject((Object)dLedgerConfig);
        JCommander jc = builder.build();
        jc.parse(args);
        final DLedgerServer dLedgerServer = new DLedgerServer(dLedgerConfig);
        dLedgerServer.startup();
        logger.info("[{}] group {} start ok with config {}", new Object[]{dLedgerConfig.getSelfId(), dLedgerConfig.getGroup(), JSON.toJSONString((Object)dLedgerConfig)});
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
            private volatile boolean hasShutdown = false;
            private AtomicInteger shutdownTimes = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    logger.info("Shutdown hook was invoked, {}", (Object)this.shutdownTimes.incrementAndGet());
                    if (!this.hasShutdown) {
                        this.hasShutdown = true;
                        long beginTime = System.currentTimeMillis();
                        dLedgerServer.shutdown();
                        long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                        logger.info("Shutdown hook over, consuming total time(ms): {}", (Object)consumingTimeTotal);
                    }
                }
            }
        }, "ShutdownHook"));
    }
}

